/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.guvnor.ala.config.CloneableConfig;

public final class VariableInterpolation {
    private static final ConfigurationInterpolator interpolator = new ConfigurationInterpolator();
    private static final StrSubstitutor substitutor = new StrSubstitutor((StrLookup)interpolator);

    private VariableInterpolation() {
    }

    public static <T> T interpolate(Map<String, Object> values, T object) {
        interpolator.setDefaultLookup((StrLookup)new MapOfMapStrLookup(values));
        return VariableInterpolation.proxy(object);
    }

    public static <T> T proxy(T instance) {
        try {
            Type[] _interfaces = instance.getClass().getInterfaces().length == 0 ? instance.getClass().getSuperclass().getInterfaces() : instance.getClass().getInterfaces();
            Object result = new ByteBuddy().subclass(Object.class).implement(_interfaces).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new InterpolationHandler(instance))).make().load(instance.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().newInstance();
            if (instance instanceof CloneableConfig) {
                return ((CloneableConfig)result).asNewClone(result);
            }
            return result;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return instance;
        }
    }

    public static class InterpolationHandler
    implements InvocationHandler {
        Object object;

        public InterpolationHandler(Object object) {
            this.object = object;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke(this.object, args);
            if (result != null && result instanceof String) {
                return substitutor.replace((String)result);
            }
            return result;
        }
    }

    private static class MapOfMapStrLookup
    extends StrLookup {
        private final Map map;

        MapOfMapStrLookup(Map map) {
            this.map = map;
        }

        public String lookup(String key) {
            if (this.map == null) {
                return null;
            }
            int dotIndex = key.indexOf(".");
            Object obj = this.map.get(key.substring(0, dotIndex < 0 ? key.length() : dotIndex));
            if (obj instanceof Map) {
                return new MapOfMapStrLookup((Map)obj).lookup(key.substring(key.indexOf(".") + 1));
            }
            if (obj != null && !(obj instanceof String) && key.contains(".")) {
                String subkey = key.substring(key.indexOf(".") + 1);
                for (PropertyDescriptor descriptor : new PropertyUtilsBean().getPropertyDescriptors(obj)) {
                    if (!descriptor.getName().equals(subkey)) continue;
                    try {
                        return descriptor.getReadMethod().invoke(obj, new Object[0]).toString();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            return obj == null ? "" : obj.toString();
        }
    }
}

