/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.util.Map;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.MapProjectionParameters;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

final class MapProjectionDescriptor
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = -9142116135803309453L;
    final boolean hasStandardParallels;

    MapProjectionDescriptor(Map<String, ?> map, ParameterDescriptor<?>[] parameterDescriptorArray) {
        super(map, MapProjectionDescriptor.addAxisLengths(parameterDescriptorArray));
        boolean bl = false;
        boolean bl2 = false;
        for (ParameterDescriptor<?> parameterDescriptor : parameterDescriptorArray) {
            String string = parameterDescriptor.getName().getCode();
            if (string.equals("standard_parallel_1")) {
                bl = true;
            } else if (string.equals("standard_parallel_2")) {
                bl2 = true;
            } else {
                for (GenericName genericName : parameterDescriptor.getAlias()) {
                    string = genericName.tip().toString();
                    if (string.equals("standard_parallel_1")) {
                        bl = true;
                        continue;
                    }
                    if (!string.equals("standard_parallel_2")) continue;
                    bl2 = true;
                }
            }
            if (bl & bl2) break;
        }
        this.hasStandardParallels = bl & bl2;
    }

    private static ParameterDescriptor<?>[] addAxisLengths(ParameterDescriptor<?>[] parameterDescriptorArray) {
        ParameterDescriptor[] parameterDescriptorArray2 = new ParameterDescriptor[parameterDescriptorArray.length + 2];
        parameterDescriptorArray2[0] = MapProjection.SEMI_MAJOR;
        parameterDescriptorArray2[1] = MapProjection.SEMI_MINOR;
        System.arraycopy(parameterDescriptorArray, 0, parameterDescriptorArray2, 2, parameterDescriptorArray.length);
        return parameterDescriptorArray2;
    }

    static boolean isHeuristicMatchForName(String string, String string2) {
        return CharSequences.equalsFiltered(string, string2, Characters.Filter.LETTERS_AND_DIGITS, true);
    }

    @Override
    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        if (MapProjectionDescriptor.isHeuristicMatchForName(string, "earth_radius")) {
            return MapProjectionParameters.EarthRadius.DESCRIPTOR;
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(string, "inverse_flattening")) {
            return MapProjectionParameters.InverseFlattening.DESCRIPTOR;
        }
        if (MapProjectionDescriptor.isHeuristicMatchForName(string, "is_ivf_definitive")) {
            return MapProjectionParameters.IsIvfDefinitive.DESCRIPTOR;
        }
        if (this.hasStandardParallels && MapProjectionDescriptor.isHeuristicMatchForName(string, "standard_parallel")) {
            return MapProjectionParameters.StandardParallel.DESCRIPTOR;
        }
        return super.descriptor(string);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new MapProjectionParameters(this);
    }
}

