/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.ala;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProjectConfig;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.ala.source.Source;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.backend.builder.ala.LocalProjectConfig;
import org.kie.workbench.common.services.backend.builder.ala.impl.LocalProjectImpl;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class LocalProjectConfigExecutor
implements BiFunctionConfigExecutor<Source, LocalProjectConfig, ProjectConfig> {
    private KieProjectService projectService;

    public LocalProjectConfigExecutor() {
    }

    @Inject
    public LocalProjectConfigExecutor(KieProjectService projectService) {
        this.projectService = projectService;
    }

    public Optional<ProjectConfig> apply(Source source, LocalProjectConfig localProjectConfig) {
        Project project = this.projectService.resolveProject(Paths.convert((Path)source.getPath().resolve("pom.xml")));
        return Optional.of(new LocalProjectImpl(project));
    }

    public Class<? extends Config> executeFor() {
        return LocalProjectConfig.class;
    }

    public String outputId() {
        return "local-project";
    }
}

