/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.imports.Import;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.ProjectImportsContent;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class ProjectImportsServiceImpl
extends KieService<ProjectImportsContent>
implements ProjectImportsService {
    protected IOService ioService;
    protected ProjectConfigurationContentHandler projectConfigurationContentHandler;

    public ProjectImportsServiceImpl() {
    }

    @Inject
    public ProjectImportsServiceImpl(@Named(value="ioStrategy") IOService ioService, ProjectConfigurationContentHandler projectConfigurationContentHandler) {
        this.ioService = ioService;
        this.projectConfigurationContentHandler = projectConfigurationContentHandler;
    }

    public void saveProjectImports(org.uberfire.backend.vfs.Path path) {
        if (this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)path))) {
            throw new FileAlreadyExistsException(path.toString());
        }
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.projectConfigurationContentHandler.toString(this.createProjectImports()), new OpenOption[0]);
    }

    private ProjectImports createProjectImports() {
        ProjectImports imports = new ProjectImports();
        imports.getImports().addImport(new Import("java.lang.Number"));
        return imports;
    }

    @Override
    public ProjectImportsContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (ProjectImportsContent)super.loadContent(path);
    }

    @Override
    protected ProjectImportsContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        return new ProjectImportsContent(this.load(path), overview);
    }

    public ProjectImports load(org.uberfire.backend.vfs.Path path) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            if (!this.ioService.exists(nioPath)) {
                this.saveProjectImports(path);
            }
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return this.projectConfigurationContentHandler.toModel(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ProjectImports projectImports, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.projectConfigurationContentHandler.toString(projectImports), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[0]);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

