/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;

final class GridGeometryInfo
extends GridGeometry {
    private static final Object[] AXIS_TYPES = new Object[]{"Lon", AttributeNames.LONGITUDE, "Lat", AttributeNames.LATITUDE, "Pressure", AttributeNames.VERTICAL, "Height", AttributeNames.VERTICAL, "RunTime", AttributeNames.TIME, "Time", AttributeNames.TIME};
    private final Dimension[] domain;
    private final VariableInfo[] range;

    GridGeometryInfo(Dimension[] dimensionArray, VariableInfo[] variableInfoArray) {
        this.domain = dimensionArray;
        this.range = variableInfoArray;
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.range.length;
    }

    @Override
    public Axis[] getAxes() {
        int n = this.range.length;
        Axis[] axisArray = new Axis[n];
        while (--n >= 0) {
            int n2;
            VariableInfo variableInfo = this.range[n];
            Dimension[] dimensionArray = variableInfo.dimensions;
            AttributeNames.Dimension dimension = null;
            String string = variableInfo.getAxisType();
            if (string != null) {
                for (n2 = 0; n2 < AXIS_TYPES.length; n2 += 2) {
                    if (!string.equalsIgnoreCase((String)AXIS_TYPES[n2])) continue;
                    dimension = (AttributeNames.Dimension)AXIS_TYPES[n2 + 1];
                    break;
                }
            }
            n2 = 0;
            int[] nArray = new int[dimensionArray.length];
            int[] nArray2 = new int[dimensionArray.length];
            block2: for (Dimension dimension2 : dimensionArray) {
                int n3 = this.domain.length;
                while (--n3 >= 0) {
                    if (this.domain[n3] != dimension2) continue;
                    nArray[n2] = n3;
                    nArray2[n2++] = dimension2.length;
                    continue block2;
                }
            }
            axisArray[n] = new Axis(this, dimension, ArraysExt.resize(nArray, n2), ArraysExt.resize(nArray2, n2));
        }
        return axisArray;
    }

    @Override
    protected double coordinateForCurrentAxis(int n, int n2) {
        throw new UnsupportedOperationException();
    }
}

