/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Attribute;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.resources.Errors;

final class VariableInfo
extends Variable {
    private static final String[] DESCRIPTION_ATTRIBUTES = new String[]{"long_name", "description", "title", "standard_name"};
    static final int BYTE = 1;
    static final int CHAR = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int FLOAT = 5;
    static final int DOUBLE = 6;
    private static final int[] SIZES = new int[]{1, 1, 2, 4, 4, 8};
    private static final Class<?>[] TYPES = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE};
    private final ChannelDataInput input;
    private final String name;
    final Dimension[] dimensions;
    private final Dimension[] allDimensions;
    private final Map<String, Attribute> attributes;
    private final int datatype;
    private final long offset;
    GridGeometryInfo gridGeometry;

    VariableInfo(ChannelDataInput channelDataInput, String string, Dimension[] dimensionArray, Dimension[] dimensionArray2, Map<String, Attribute> map, int n, int n2, long l) {
        this.input = channelDataInput;
        this.name = string;
        this.dimensions = dimensionArray;
        this.allDimensions = dimensionArray2;
        this.attributes = map;
        this.datatype = n;
        this.offset = l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        for (String string : DESCRIPTION_ATTRIBUTES) {
            Attribute attribute = this.attributes.get(string);
            if (attribute == null || !(attribute.value instanceof String)) continue;
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public String getUnitsString() {
        Attribute attribute = this.attributes.get("units");
        if (attribute != null && attribute.value instanceof String) {
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public Class<?> getDataType() {
        int n = this.datatype - 1;
        return n >= 0 && n < TYPES.length ? TYPES[n] : null;
    }

    static int sizeOf(int n) {
        return --n >= 0 && n < SIZES.length ? SIZES[n] : 0;
    }

    @Override
    public boolean isUnsigned() {
        Attribute attribute = this.attributes.get("_Unsigned");
        return attribute != null && attribute.booleanValue();
    }

    @Override
    public boolean isCoordinateSystemAxis() {
        String string = this.name;
        Attribute attribute = this.attributes.get("_CoordinateVariableAlias");
        if (attribute != null && attribute.value instanceof String) {
            string = (String)attribute.value;
        }
        for (Dimension dimension : this.allDimensions) {
            if (!string.equals(dimension.name)) continue;
            return true;
        }
        return false;
    }

    final String getAxisType() {
        Attribute attribute = this.attributes.get("_CoordinateAxisType");
        if (attribute != null && attribute.value instanceof String) {
            return (String)attribute.value;
        }
        return null;
    }

    @Override
    public String[] getGridDimensionNames() {
        String[] stringArray = new String[this.dimensions.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.dimensions[i].name;
        }
        return stringArray;
    }

    @Override
    public int[] getGridEnvelope() {
        int[] nArray = new int[this.dimensions.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.dimensions[i].length;
        }
        return nArray;
    }

    @Override
    public Object[] getAttributeValues(String string, boolean bl) {
        Attribute attribute = this.attributes.get(string);
        if (attribute != null) {
            return bl ? attribute.numberValues() : attribute.stringValues();
        }
        return new Object[0];
    }

    @Override
    public Object read() throws IOException, DataStoreException {
        long l = 1L;
        for (Dimension dimension : this.dimensions) {
            l *= (long)dimension.length;
        }
        if (l > Integer.MAX_VALUE) {
            throw new DataStoreException(Errors.format((short)25, this.name, l));
        }
        this.input.seek(this.offset);
        switch (this.datatype) {
            case 1: {
                return this.input.readBytes((int)l);
            }
            case 3: {
                return this.input.readShorts((int)l);
            }
            case 4: {
                return this.input.readInts((int)l);
            }
            case 5: {
                return this.input.readFloats((int)l);
            }
            case 6: {
                return this.input.readDoubles((int)l);
            }
        }
        throw new DataStoreException(Errors.format((short)118, this.datatype));
    }
}

