/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Resource;
import org.apache.log4j.Logger;

public class ResourceComputationStage
extends AbstractBaseStage {
    private static Logger LOG = Logger.getLogger(ResourceComputationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        Map<String, LiveInstance> availableInstances;
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        if (cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache");
        }
        Map<String, IdealState> idealStates = cache.getIdealStates();
        LinkedHashMap<String, Resource> resourceMap = new LinkedHashMap<String, Resource>();
        if (idealStates != null && idealStates.size() > 0) {
            for (IdealState idealState : idealStates.values()) {
                Set<String> partitionSet = idealState.getPartitionSet();
                String resourceName = idealState.getResourceName();
                if (!resourceMap.containsKey(resourceName)) {
                    Resource resource = new Resource(resourceName);
                    resourceMap.put(resourceName, resource);
                    resource.setStateModelDefRef(idealState.getStateModelDefRef());
                    resource.setStateModelFactoryName(idealState.getStateModelFactoryName());
                    resource.setBucketSize(idealState.getBucketSize());
                    resource.setBatchMessageMode(idealState.getBatchMessageMode());
                }
                for (String partition : partitionSet) {
                    this.addPartition(partition, resourceName, resourceMap);
                }
            }
        }
        if ((availableInstances = cache.getLiveInstances()) != null && availableInstances.size() > 0) {
            for (LiveInstance instance : availableInstances.values()) {
                String clientSessionId;
                String instanceName = instance.getInstanceName();
                Map<String, CurrentState> currentStateMap = cache.getCurrentState(instanceName, clientSessionId = instance.getSessionId());
                if (currentStateMap == null || currentStateMap.size() == 0) continue;
                for (CurrentState currentState : currentStateMap.values()) {
                    String resourceName = currentState.getResourceName();
                    Map<String, String> resourceStateMap = currentState.getPartitionStateMap();
                    if (resourceStateMap.keySet().isEmpty()) continue;
                    if (!resourceMap.containsKey(resourceName)) {
                        this.addResource(resourceName, resourceMap);
                        Resource resource = (Resource)resourceMap.get(resourceName);
                        resource.setStateModelDefRef(currentState.getStateModelDefRef());
                        resource.setStateModelFactoryName(currentState.getStateModelFactoryName());
                        resource.setBucketSize(currentState.getBucketSize());
                        resource.setBatchMessageMode(currentState.getBatchMessageMode());
                    }
                    if (currentState.getStateModelDefRef() == null) {
                        LOG.error((Object)("state model def is null.resource:" + currentState.getResourceName() + ", partitions: " + currentState.getPartitionStateMap().keySet() + ", states: " + currentState.getPartitionStateMap().values()));
                        throw new StageException("State model def is null for resource:" + currentState.getResourceName());
                    }
                    for (String partition : resourceStateMap.keySet()) {
                        this.addPartition(partition, resourceName, resourceMap);
                    }
                }
            }
        }
        event.addAttribute(AttributeName.RESOURCES.toString(), resourceMap);
    }

    private void addResource(String resource, Map<String, Resource> resourceMap) {
        if (resource == null || resourceMap == null) {
            return;
        }
        if (!resourceMap.containsKey(resource)) {
            resourceMap.put(resource, new Resource(resource));
        }
    }

    private void addPartition(String partition, String resourceName, Map<String, Resource> resourceMap) {
        if (resourceName == null || partition == null || resourceMap == null) {
            return;
        }
        if (!resourceMap.containsKey(resourceName)) {
            resourceMap.put(resourceName, new Resource(resourceName));
        }
        Resource resource = resourceMap.get(resourceName);
        resource.addPartition(partition);
    }
}

