/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.Asynchronous;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.builder.AsyncIncrementalBuilder;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.DescriptiveThreadFactory;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class IncrementalBuilderExecutorManager {
    @Inject
    private ProjectService<? extends Project> projectService;
    @Inject
    private BuildService buildService;
    @Inject
    private Event<BuildResults> buildResultsEvent;
    @Inject
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    private AtomicBoolean useExecService = new AtomicBoolean(false);
    private ExecutorService executorService = null;

    @Asynchronous
    public void execute(final AsyncIncrementalBuilder incrementalBuilder) {
        if (this.useExecService.get()) {
            this.getExecutorService().execute((Runnable)new DescriptiveRunnable(){

                public void run() {
                    incrementalBuilder.execute(IncrementalBuilderExecutorManager.this.projectService, IncrementalBuilderExecutorManager.this.buildService, (Event<IncrementalBuildResults>)IncrementalBuilderExecutorManager.this.incrementalBuildResultsEvent, (Event<BuildResults>)IncrementalBuilderExecutorManager.this.buildResultsEvent);
                }

                public String getDescription() {
                    return incrementalBuilder.getDescription();
                }
            });
        } else {
            incrementalBuilder.execute(this.projectService, this.buildService, this.incrementalBuildResultsEvent, this.buildResultsEvent);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.useExecService.set(true);
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory());
        }
        return this.executorService;
    }

    public void setServices(ProjectService projectService, BuildService buildService, Event<BuildResults> buildResultsEvent, Event<IncrementalBuildResults> incrementalBuildResultsEvent) {
        this.projectService = projectService;
        this.buildService = buildService;
        this.buildResultsEvent = buildResultsEvent;
        this.incrementalBuildResultsEvent = incrementalBuildResultsEvent;
        this.useExecService.set(true);
    }

    public void shutdown() {
        if (this.useExecService.get() && this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                        System.err.println("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

