/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service.naming;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.PathNamingService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class PathNamingServiceImpl
implements PathNamingService {
    @Inject
    private Instance<ResourceTypeDefinition> resourceTypeDefinitions;

    public org.uberfire.backend.vfs.Path buildTargetPath(org.uberfire.backend.vfs.Path originalPath, String targetFileName) {
        Path _originalPath = Paths.convert((org.uberfire.backend.vfs.Path)originalPath);
        String extension = "";
        if (!Files.isDirectory((Path)_originalPath, (LinkOption[])new LinkOption[0])) {
            extension = this.getExtension(originalPath.getFileName());
        }
        return Paths.convert((Path)_originalPath.resolveSibling(targetFileName + extension));
    }

    public org.uberfire.backend.vfs.Path buildTargetPath(org.uberfire.backend.vfs.Path originalPath, org.uberfire.backend.vfs.Path targetParentDirectory, String targetFileName) {
        Path _originalPath = Paths.convert((org.uberfire.backend.vfs.Path)originalPath);
        Path _targetParentDirectory = Paths.convert((org.uberfire.backend.vfs.Path)targetParentDirectory);
        String extension = "";
        if (!Files.isDirectory((Path)_originalPath, (LinkOption[])new LinkOption[0])) {
            extension = this.getExtension(originalPath.getFileName());
        }
        return Paths.convert((Path)_targetParentDirectory.resolve(targetFileName + extension));
    }

    public String getExtension(String fileName) {
        String extension = this.getResourceTypeExtension(fileName);
        if (extension == null) {
            extension = "";
            int extensionIndex = fileName.lastIndexOf(".");
            if (extensionIndex >= 0) {
                extension = fileName.substring(extensionIndex);
            }
        }
        return extension;
    }

    private String getResourceTypeExtension(String fileName) {
        String extension = null;
        for (ResourceTypeDefinition resourceTypeDefinition : this.getResourceTypeDefinitions()) {
            String resourceTypeExtension;
            if (resourceTypeDefinition.getSuffix() == null || !fileName.endsWith(resourceTypeExtension = "." + resourceTypeDefinition.getSuffix()) || extension != null && resourceTypeExtension.length() <= extension.length()) continue;
            extension = resourceTypeExtension;
        }
        return extension;
    }

    public Iterable<ResourceTypeDefinition> getResourceTypeDefinitions() {
        return this.resourceTypeDefinitions;
    }
}

