/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import java.util.Locale;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public final class NameToIdentifier
implements ReferenceIdentifier {
    private final GenericName name;

    public NameToIdentifier(GenericName genericName) {
        ArgumentChecks.ensureNonNull("name", genericName);
        this.name = genericName;
    }

    private static GenericName scope(GenericName genericName) {
        NameSpace nameSpace;
        if (genericName != null && (nameSpace = genericName.scope()) != null && !nameSpace.isGlobal()) {
            return nameSpace.name();
        }
        return null;
    }

    @Override
    public Citation getAuthority() {
        GenericName genericName = NameToIdentifier.scope(this.name);
        if (genericName == null && (genericName = NameToIdentifier.scope(this.name.tip())) == null) {
            return null;
        }
        return Citations.fromName(genericName.head().toString());
    }

    public static String getCodeSpace(GenericName genericName, Locale locale) {
        GenericName genericName2 = NameToIdentifier.scope(genericName.tip());
        return genericName2 != null ? NameToIdentifier.toString(genericName2.tip(), locale) : null;
    }

    @Override
    public String getCodeSpace() {
        return NameToIdentifier.getCodeSpace(this.name, null);
    }

    @Override
    public String getCode() {
        return this.name.tip().toString();
    }

    @Override
    public String getVersion() {
        return null;
    }

    public int hashCode() {
        return ~Objects.hashCode(this.name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return Objects.equals(this.name, ((NameToIdentifier)object).name);
        }
        return false;
    }

    public String toString() {
        String string = this.getCode();
        String string2 = this.getCodeSpace();
        if (string2 != null && !string2.isEmpty()) {
            return string2 + ':' + string;
        }
        return string;
    }

    public static String toString(GenericName genericName, Locale locale) {
        if (genericName != null) {
            String string;
            InternationalString internationalString;
            if (locale != null && (internationalString = genericName.toInternationalString()) != null && (string = internationalString.toString(locale)) != null) {
                return string;
            }
            return genericName.toString();
        }
        return null;
    }

    public static boolean isHeuristicMatchForName(Identifier identifier, Collection<GenericName> collection, CharSequence charSequence) {
        Object object;
        charSequence = CharSequences.toASCII(charSequence);
        if (identifier != null && (object = CharSequences.toASCII(identifier.getCode())) != null && CharSequences.equalsFiltered(charSequence, (CharSequence)object, Characters.Filter.LETTERS_AND_DIGITS, true)) {
            return true;
        }
        if (collection != null) {
            for (GenericName genericName : collection) {
                CharSequence charSequence2;
                if (genericName == null || !CharSequences.equalsFiltered(charSequence, charSequence2 = CharSequences.toASCII(genericName.tip().toString()), Characters.Filter.LETTERS_AND_DIGITS, true)) continue;
                return true;
            }
        }
        return false;
    }
}

