/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultAggregateInformation;
import org.apache.sis.metadata.iso.identification.DefaultAssociatedResource;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultServiceIdentification;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractMD_Identification_Type", propOrder={"citation", "abstract", "purpose", "credits", "status", "pointOfContacts", "resourceMaintenances", "graphicOverviews", "resourceFormats", "descriptiveKeywords", "resourceSpecificUsages", "resourceConstraints", "aggregationInfo", "spatialRepresentationTypes", "spatialResolutions"})
@XmlRootElement(name="MD_Identification")
@XmlSeeAlso(value={DefaultDataIdentification.class, DefaultServiceIdentification.class})
public class AbstractIdentification
extends ISOMetadata
implements Identification {
    private static final long serialVersionUID = 157053637951213015L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection<String> credits;
    private Collection<Progress> status;
    private Collection<ResponsibleParty> pointOfContacts;
    private Collection<SpatialRepresentationType> spatialRepresentationTypes;
    private Collection<Resolution> spatialResolutions;
    private Collection<TopicCategory> topicCategories;
    private Collection<Extent> extents;
    private Collection<Citation> additionalDocumentations;
    private Identifier processingLevel;
    private Collection<MaintenanceInformation> resourceMaintenances;
    private Collection<BrowseGraphic> graphicOverviews;
    private Collection<Format> resourceFormats;
    private Collection<Keywords> descriptiveKeywords;
    private Collection<Usage> resourceSpecificUsages;
    private Collection<Constraints> resourceConstraints;
    private Collection<DefaultAssociatedResource> associatedResources;

    public AbstractIdentification() {
    }

    public AbstractIdentification(Citation citation, CharSequence charSequence) {
        this.citation = citation;
        this.abstracts = Types.toInternationalString(charSequence);
    }

    public AbstractIdentification(Identification identification) {
        super(identification);
        if (identification != null) {
            this.citation = identification.getCitation();
            this.abstracts = identification.getAbstract();
            this.purpose = identification.getPurpose();
            this.credits = this.copyCollection(identification.getCredits(), String.class);
            this.status = this.copyCollection(identification.getStatus(), Progress.class);
            this.pointOfContacts = this.copyCollection(identification.getPointOfContacts(), ResponsibleParty.class);
            this.resourceMaintenances = this.copyCollection(identification.getResourceMaintenances(), MaintenanceInformation.class);
            this.graphicOverviews = this.copyCollection(identification.getGraphicOverviews(), BrowseGraphic.class);
            this.resourceFormats = this.copyCollection(identification.getResourceFormats(), Format.class);
            this.descriptiveKeywords = this.copyCollection(identification.getDescriptiveKeywords(), Keywords.class);
            this.resourceSpecificUsages = this.copyCollection(identification.getResourceSpecificUsages(), Usage.class);
            this.resourceConstraints = this.copyCollection(identification.getResourceConstraints(), Constraints.class);
            if (identification instanceof AbstractIdentification) {
                AbstractIdentification abstractIdentification = (AbstractIdentification)identification;
                this.spatialRepresentationTypes = this.copyCollection(abstractIdentification.getSpatialRepresentationTypes(), SpatialRepresentationType.class);
                this.spatialResolutions = this.copyCollection(abstractIdentification.getSpatialResolutions(), Resolution.class);
                this.topicCategories = this.copyCollection(abstractIdentification.getTopicCategories(), TopicCategory.class);
                this.extents = this.copyCollection(abstractIdentification.getExtents(), Extent.class);
                this.additionalDocumentations = this.copyCollection(abstractIdentification.getAdditionalDocumentations(), Citation.class);
                this.processingLevel = abstractIdentification.getProcessingLevel();
                this.associatedResources = this.copyCollection(abstractIdentification.getAssociatedResources(), DefaultAssociatedResource.class);
            } else {
                this.setAggregationInfo(identification.getAggregationInfo());
            }
        }
    }

    public static AbstractIdentification castOrCopy(Identification identification) {
        if (identification instanceof DataIdentification) {
            return DefaultDataIdentification.castOrCopy((DataIdentification)identification);
        }
        if (identification instanceof ServiceIdentification) {
            return DefaultServiceIdentification.castOrCopy((ServiceIdentification)identification);
        }
        if (identification == null || identification instanceof AbstractIdentification) {
            return (AbstractIdentification)identification;
        }
        return new AbstractIdentification(identification);
    }

    @Override
    @XmlElement(name="citation", required=true)
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="abstract", required=true)
    public InternationalString getAbstract() {
        return this.abstracts;
    }

    public void setAbstract(InternationalString internationalString) {
        this.checkWritePermission();
        this.abstracts = internationalString;
    }

    @Override
    @XmlElement(name="purpose")
    public InternationalString getPurpose() {
        return this.purpose;
    }

    public void setPurpose(InternationalString internationalString) {
        this.checkWritePermission();
        this.purpose = internationalString;
    }

    @Override
    @XmlElement(name="credit")
    public Collection<String> getCredits() {
        this.credits = this.nonNullCollection(this.credits, String.class);
        return this.credits;
    }

    public void setCredits(Collection<? extends String> collection) {
        this.credits = this.writeCollection(collection, this.credits, String.class);
    }

    @Override
    @XmlElement(name="status")
    public Collection<Progress> getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public void setStatus(Collection<? extends Progress> collection) {
        this.status = this.writeCollection(collection, this.status, Progress.class);
    }

    @XmlElement(name="pointOfContact")
    public Collection<ResponsibleParty> getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, ResponsibleParty.class);
        return this.pointOfContacts;
    }

    public void setPointOfContacts(Collection<? extends ResponsibleParty> collection) {
        this.pointOfContacts = this.writeCollection(collection, this.pointOfContacts, ResponsibleParty.class);
    }

    @XmlElement(name="spatialRepresentationType")
    @UML(identifier="spatialRepresentationType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<SpatialRepresentationType> getSpatialRepresentationTypes() {
        this.spatialRepresentationTypes = this.nonNullCollection(this.spatialRepresentationTypes, SpatialRepresentationType.class);
        return this.spatialRepresentationTypes;
    }

    public void setSpatialRepresentationTypes(Collection<? extends SpatialRepresentationType> collection) {
        this.spatialRepresentationTypes = this.writeCollection(collection, this.spatialRepresentationTypes, SpatialRepresentationType.class);
    }

    @XmlElement(name="spatialResolution")
    @UML(identifier="spatialResolution", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Resolution> getSpatialResolutions() {
        this.spatialResolutions = this.nonNullCollection(this.spatialResolutions, Resolution.class);
        return this.spatialResolutions;
    }

    public void setSpatialResolutions(Collection<? extends Resolution> collection) {
        this.spatialResolutions = this.writeCollection(collection, this.spatialResolutions, Resolution.class);
    }

    @UML(identifier="topicCategory", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<TopicCategory> getTopicCategories() {
        this.topicCategories = this.nonNullCollection(this.topicCategories, TopicCategory.class);
        return this.topicCategories;
    }

    public void setTopicCategories(Collection<? extends TopicCategory> collection) {
        this.topicCategories = this.writeCollection(collection, this.topicCategories, TopicCategory.class);
    }

    @UML(identifier="extent", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> collection) {
        this.extents = this.writeCollection(collection, this.extents, Extent.class);
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentations() {
        this.additionalDocumentations = this.nonNullCollection(this.additionalDocumentations, Citation.class);
        return this.additionalDocumentations;
    }

    public void setAdditionalDocumentations(Collection<? extends Citation> collection) {
        this.additionalDocumentations = this.writeCollection(collection, this.additionalDocumentations, Citation.class);
    }

    @UML(identifier="processingLevel", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getProcessingLevel() {
        return this.processingLevel;
    }

    public void setProcessingLevel(Identifier identifier) {
        this.checkWritePermission();
        this.processingLevel = identifier;
    }

    @XmlElement(name="resourceMaintenance")
    public Collection<MaintenanceInformation> getResourceMaintenances() {
        this.resourceMaintenances = this.nonNullCollection(this.resourceMaintenances, MaintenanceInformation.class);
        return this.resourceMaintenances;
    }

    public void setResourceMaintenances(Collection<? extends MaintenanceInformation> collection) {
        this.resourceMaintenances = this.writeCollection(collection, this.resourceMaintenances, MaintenanceInformation.class);
    }

    @XmlElement(name="graphicOverview")
    public Collection<BrowseGraphic> getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public void setGraphicOverviews(Collection<? extends BrowseGraphic> collection) {
        this.graphicOverviews = this.writeCollection(collection, this.graphicOverviews, BrowseGraphic.class);
    }

    @XmlElement(name="resourceFormat")
    public Collection<Format> getResourceFormats() {
        this.resourceFormats = this.nonNullCollection(this.resourceFormats, Format.class);
        return this.resourceFormats;
    }

    public void setResourceFormats(Collection<? extends Format> collection) {
        this.resourceFormats = this.writeCollection(collection, this.resourceFormats, Format.class);
    }

    @XmlElement(name="descriptiveKeywords")
    public Collection<Keywords> getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public void setDescriptiveKeywords(Collection<? extends Keywords> collection) {
        this.descriptiveKeywords = this.writeCollection(collection, this.descriptiveKeywords, Keywords.class);
    }

    @XmlElement(name="resourceSpecificUsage")
    public Collection<Usage> getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public void setResourceSpecificUsages(Collection<? extends Usage> collection) {
        this.resourceSpecificUsages = this.writeCollection(collection, this.resourceSpecificUsages, Usage.class);
    }

    @XmlElement(name="resourceConstraints")
    public Collection<Constraints> getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public void setResourceConstraints(Collection<? extends Constraints> collection) {
        this.resourceConstraints = this.writeCollection(collection, this.resourceConstraints, Constraints.class);
    }

    @UML(identifier="associatedResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultAssociatedResource> getAssociatedResources() {
        this.associatedResources = this.nonNullCollection(this.associatedResources, DefaultAssociatedResource.class);
        return this.associatedResources;
    }

    public void setAssociatedResources(Collection<? extends DefaultAssociatedResource> collection) {
        this.associatedResources = this.writeCollection(collection, this.associatedResources, DefaultAssociatedResource.class);
    }

    @Deprecated
    @XmlElement(name="aggregationInfo")
    public Collection<AggregateInformation> getAggregationInfo() {
        return new LegacyPropertyAdapter<AggregateInformation, DefaultAssociatedResource>(this.getAssociatedResources()){

            @Override
            protected DefaultAssociatedResource wrap(AggregateInformation aggregateInformation) {
                return DefaultAssociatedResource.castOrCopy(aggregateInformation);
            }

            @Override
            protected AggregateInformation unwrap(DefaultAssociatedResource defaultAssociatedResource) {
                if (defaultAssociatedResource instanceof AggregateInformation) {
                    return (AggregateInformation)((Object)defaultAssociatedResource);
                }
                return new DefaultAggregateInformation(defaultAssociatedResource);
            }

            @Override
            protected boolean update(DefaultAssociatedResource defaultAssociatedResource, AggregateInformation aggregateInformation) {
                return defaultAssociatedResource == aggregateInformation;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setAggregationInfo(Collection<? extends AggregateInformation> collection) {
        this.checkWritePermission();
        ArrayList<DefaultAssociatedResource> arrayList = null;
        if (collection != null) {
            arrayList = new ArrayList<DefaultAssociatedResource>(collection.size());
            for (AggregateInformation aggregateInformation : collection) {
                arrayList.add(DefaultAssociatedResource.castOrCopy(aggregateInformation));
            }
        }
        this.setAssociatedResources(arrayList);
    }
}

