/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.local;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.Source;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class InMemorySourceRegistry
implements SourceRegistry {
    private final Map<Path, Repository> repositorySourcesPath = new ConcurrentHashMap<Path, Repository>();
    private final Map<String, Path> pathByRepositoryId = new ConcurrentHashMap<String, Path>();
    private final Map<Repository, List<Project>> projectsByRepo = new ConcurrentHashMap<Repository, List<Project>>();
    private final Map<Repository, List<Source>> sourceByRepo = new ConcurrentHashMap<Repository, List<Source>>();
    private final Map<Source, Project> projectBySource = new ConcurrentHashMap<Source, Project>();

    public void registerRepositorySources(Path path, Repository repo) {
        this.repositorySourcesPath.put(path, repo);
        this.pathByRepositoryId.put(repo.getId(), path);
    }

    public Path getRepositoryPath(Repository repo) {
        return this.pathByRepositoryId.get(repo.getId());
    }

    public Path getRepositoryPathById(String repoId) {
        return this.pathByRepositoryId.get(repoId);
    }

    public Repository getRepositoryByPath(Path path) {
        return this.repositorySourcesPath.get(path);
    }

    public List<Repository> getAllRepositories() {
        return new ArrayList<Repository>(this.repositorySourcesPath.values());
    }

    public void registerProject(Repository repo, Project project) {
        this.projectsByRepo.putIfAbsent(repo, new ArrayList());
        this.projectsByRepo.get(repo).add(project);
    }

    public List<Project> getAllProjects(Repository repository) {
        Path repoPath = this.pathByRepositoryId.get(repository.getId());
        ArrayList<Project> allProjects = new ArrayList<Project>();
        for (Source s : this.projectBySource.keySet()) {
            if (!this.projectBySource.get(s).getRootPath().equals(repoPath)) continue;
            allProjects.add(this.projectBySource.get(s));
        }
        return allProjects;
    }

    public Project getProjectByName(String projectName) {
        for (Source s : this.projectBySource.keySet()) {
            if (!this.projectBySource.get(s).getName().equals(projectName)) continue;
            return this.projectBySource.get(s);
        }
        return null;
    }

    public Repository getRepositoryById(String repositoryId) {
        return this.repositorySourcesPath.get(this.pathByRepositoryId.get(repositoryId));
    }

    public void registerSource(Repository repo, Source source) {
        this.sourceByRepo.putIfAbsent(repo, new ArrayList());
        this.sourceByRepo.get(repo).add(source);
    }

    public void registerProject(Source source, Project project) {
        this.projectBySource.put(source, project);
    }
}

