/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import javax.enterprise.inject.spi.Unmanaged;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;

public class WeldSEProvider
implements CDIProvider {
    private final ComputingCache<String, WeldContainer> containers = ComputingCacheBuilder.newBuilder().setWeakValues().build((Function)new ClassNameToWeldContainer());
    private final Set<String> knownClassNames;

    public WeldSEProvider() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            names.add((Object)clazz.getName());
        }
        names.add((Object)Unmanaged.class.getName());
        names.add((Object)CDI.class.getName());
        this.knownClassNames = names.build();
    }

    public CDI<Object> getCDI() {
        List<String> ids = WeldContainer.getRunningContainerIds();
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return WeldContainer.instance(ids.get(0));
        }
        WeldSELogger.LOG.multipleContainersRunning(ids);
        String caller = this.getCallingClassName();
        if (caller != null) {
            return (CDI)this.containers.getValue((Object)caller);
        }
        return WeldContainer.instance(ids.get(0));
    }

    private String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.knownClassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        return null;
    }

    private static class ClassNameToWeldContainer
    implements Function<String, WeldContainer> {
        private ClassNameToWeldContainer() {
        }

        public WeldContainer apply(String callerClassName) {
            List<String> ids = WeldContainer.getRunningContainerIds();
            for (String containerId : ids) {
                Container container = Container.instance((String)containerId);
                for (Map.Entry entry : container.beanDeploymentArchives().entrySet()) {
                    for (String className : ((BeanDeploymentArchive)entry.getKey()).getBeanClasses()) {
                        if (!className.equals(callerClassName)) continue;
                        return WeldContainer.instance(containerId);
                    }
                }
            }
            return WeldContainer.instance(ids.get(0));
        }
    }
}

