/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.util;

import org.drools.workbench.jcr2vfsmigration.util.ExportUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExportUtilsTest {
    @Test
    public void shouldMigrateStartOfCommentInLineStartingWithWhiteSpaces() {
        this.migrateCommentsAndAssertResult("  \t  \t some text # some comment", "  \t  \t some text // some comment");
    }

    @Test
    public void shouldMigrateStartOfCommentInLineStartingWithComment() {
        this.migrateCommentsAndAssertResult("# some comment", "// some comment");
    }

    @Test
    public void shouldNotMigrateStartOfCommentInsideDoubleQuotes() {
        this.migrateCommentsAndAssertResult("hash tag \" # inside double quotes\"", "hash tag \" # inside double quotes\"");
    }

    @Test
    public void shouldNotMigrateStartOfCommentInsideSingleQuotes() {
        this.migrateCommentsAndAssertResult("hash tag ' # inside single quotes'", "hash tag ' # inside single quotes'");
    }

    @Test
    public void shouldNotMigrateDslDebugConstruct() {
        this.migrateCommentsAndAssertResult("some text #/", "some text #/");
        this.migrateCommentsAndAssertResult("#/ some text # some comment", "#/ some text // some comment");
    }

    @Test
    public void shouldMigrateStartOfCommentIgnoringEscapedQuotes() {
        this.migrateCommentsAndAssertResult("\"smtg \\\" # - should not be migrated\\\"\"", "\"smtg \\\" # - should not be migrated\\\"\"");
        this.migrateCommentsAndAssertResult("'smtg \\' # - should not be migrated\\''", "'smtg \\' # - should not be migrated\\''");
    }

    @Test
    public void shouldMigrateStartOfCommentInMultilineInput() {
        String input = "#/ some DSL debug value\nrule \"test rule\"\nwhen\n    Object(\"'#'this has sign should not be migrated\") # some comment\nthen\n    # some other comment\n    System.out.println(\"#8 this one neither\");\nend\n";
        String expectedResult = "#/ some DSL debug value\nrule \"test rule\"\nwhen\n    Object(\"'#'this has sign should not be migrated\") // some comment\nthen\n    // some other comment\n    System.out.println(\"#8 this one neither\");\nend\n";
        this.migrateCommentsAndAssertResult(input, expectedResult);
    }

    private void migrateCommentsAndAssertResult(String input, String expectedResult) {
        String actualResult = ExportUtils.migrateStartOfCommentChar((String)input);
        Assert.assertEquals((String)"Start of comment char not correctly migrated (# -> //)!", (Object)expectedResult, (Object)actualResult);
    }
}

