/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.drools.guvnor.server.repository.GuvnorBootstrapConfiguration;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.config.FSExportConfig;
import org.drools.workbench.jcr2vfsmigration.jcrExport.CategoryExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.ModuleAssetExporter;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrExporter {
    private static final Logger logger = LoggerFactory.getLogger(JcrExporter.class);
    @Inject
    protected FSExportConfig exportConfig;
    @Inject
    FileManager fileManager;
    @Inject
    protected CategoryExporter categoryExporter;
    @Inject
    protected ModuleAssetExporter moduleAssetExporter;
    @Inject
    protected GuvnorBootstrapConfiguration guvnorBootstrapConfiguration;
    @Inject
    protected BoundSessionContext sessionContext;
    protected Map<String, Object> sessionDataStore;
    @Inject
    protected BoundRequestContext requestContext;
    protected Map<String, Object> requestDataStore;

    public boolean parseArgs(String[] args) {
        boolean ok = this.exportConfig.parseArgs(args);
        if (ok) {
            this.fileManager.setExportTempDir(this.exportConfig.getExportTempDir());
        }
        return ok;
    }

    public void exportAll() {
        logger.info("Export from JCR started. Reading from repository {}.", (Object)this.exportConfig.getInputJcrRepository().getAbsolutePath());
        try {
            this.setupDirectories();
            this.startContexts();
            this.categoryExporter.exportAll();
            this.moduleAssetExporter.exportAll();
            this.endContexts();
            logger.info("Export from JCR ended.");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Unexpected error encountered while exporting the content of JCR repository!", t);
        }
    }

    protected void setupDirectories() {
        this.guvnorBootstrapConfiguration.getProperties().put("repository.root.directory", this.determineJcrRepositoryRootDirectory());
    }

    protected String determineJcrRepositoryRootDirectory() {
        File inputJcrRepository = this.exportConfig.getInputJcrRepository();
        File repositoryXmlFile = new File(inputJcrRepository, "repository.xml");
        if (!repositoryXmlFile.exists()) {
            throw new IllegalStateException("The repositoryXmlFile (" + repositoryXmlFile.getAbsolutePath() + ") does not exist.\n" + "Check your inputJcrRepository (" + inputJcrRepository + ").");
        }
        File repositoryDir = new File(inputJcrRepository, "repository");
        if (!repositoryDir.exists()) {
            return inputJcrRepository.getAbsolutePath();
        }
        File unnestedVersionDir = new File(inputJcrRepository, "version");
        File nestedVersionDir = new File(repositoryDir, "version");
        if (unnestedVersionDir.exists()) {
            return inputJcrRepository.getAbsolutePath();
        }
        if (nestedVersionDir.exists()) {
            try {
                FileUtils.copyFile((File)repositoryXmlFile, (File)new File(repositoryDir, "repository.xml"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot copy repositoryXmlFile (" + repositoryXmlFile + ").", e);
            }
            return inputJcrRepository.getAbsolutePath() + "/repository";
        }
        return inputJcrRepository.getAbsolutePath();
    }

    protected void startContexts() {
        this.sessionDataStore = new HashMap<String, Object>();
        this.sessionContext.associate(this.sessionDataStore);
        this.sessionContext.activate();
        this.requestDataStore = new HashMap<String, Object>();
        this.requestContext.associate(this.requestDataStore);
        this.requestContext.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endContexts() {
        try {
            this.requestContext.invalidate();
            this.requestContext.deactivate();
        }
        finally {
            this.requestContext.dissociate(this.requestDataStore);
        }
        try {
            this.sessionContext.invalidate();
            this.sessionContext.deactivate();
        }
        finally {
            this.sessionContext.dissociate(this.sessionDataStore);
        }
    }
}

