/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.services.rest.DefaultGuvnorApprover;
import org.kie.workbench.common.services.rest.ProjectResourceDispatcher;
import org.kie.workbench.common.services.shared.rest.CloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;

@ApplicationScoped
public class KieSessionAsyncJobRequestObserver {
    @Inject
    protected ProjectResourceDispatcher projectResourceDispatcher;
    @Inject
    protected DefaultGuvnorApprover defaultGuvnorApprover;
    @Inject
    private Event<JobResult> jobResultEvent;

    public void onCloneRepositoryRequest(@Observes CloneRepositoryRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.cloneRepository(jobRequest.getJodId(), jobRequest.getRepository());
    }

    public void onCreateProjectRequest(@Observes CreateProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onCompileProjectRequest(@Observes CompileProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.compileProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onInstallProjectRequest(@Observes InstallProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.installProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public boolean approveRequest(JobRequest jobRequest) {
        if (!this.defaultGuvnorApprover.requestApproval(jobRequest)) {
            JobResult result = new JobResult();
            result.setJodId(jobRequest.getJodId());
            result.setStatus(JobRequest.Status.DENIED);
            result.setResult("The request is denied.");
            this.jobResultEvent.fire((Object)result);
            return false;
        }
        return true;
    }
}

