/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.rest;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.resteasy.annotations.GZIP;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.FileSystemId;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.services.shared.rest.BuildConfig;
import org.kie.workbench.common.services.shared.rest.CloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateGroupRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.Entity;
import org.kie.workbench.common.services.shared.rest.Group;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.Repository;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;
import org.uberfire.backend.group.GroupService;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.server.util.Paths;

@javax.ws.rs.Path(value="/")
@Named
@GZIP
@ApplicationScoped
public class ProjectResource {
    private HttpHeaders headers;
    @Context
    protected UriInfo uriInfo;
    @Inject
    protected ProjectService projectService;
    @Inject
    protected BuildService buildService;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    GroupService groupService;
    @Inject
    RepositoryService repositoryService;
    private Cache cache;
    private Map<String, JobRequest> jobs;
    private AtomicLong counter = new AtomicLong(0L);
    private int maxCacheSize = 10000;
    @Inject
    private Event<CloneRepositoryRequest> cloneJobRequestEvent;
    @Inject
    private Event<CreateProjectRequest> createProjectRequestEvent;
    @Inject
    private Event<CompileProjectRequest> compileProjectRequestEvent;
    @Inject
    private Event<InstallProjectRequest> installProjectRequestEvent;
    @Inject
    private Event<TestProjectRequest> testProjectRequestEvent;
    @Inject
    private Event<DeployProjectRequest> deployProjectRequestEvent;
    @Inject
    private Event<CreateGroupRequest> createGroupRequestEvent;

    @PostConstruct
    public void start() {
        this.cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(this.cache);
    }

    @Context
    public void setHttpHeaders(HttpHeaders theHeaders) {
        this.headers = theHeaders;
    }

    public void onUpateJobStatus(@Observes JobResult jobResult) {
        JobRequest job = this.jobs.get(jobResult.getJodId());
        if (job == null) {
            return;
        }
        job.setStatus(jobResult.getStatus());
        job.setResult(jobResult.getResult());
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/jobs/{jobId}")
    public JobRequest getJobStatus(@PathParam(value="jobId") String jobId) {
        System.out.println("-----getJobStatus--- , jobId:" + jobId);
        JobRequest job = this.jobs.get(jobId);
        if (job == null) {
            job = new JobRequest();
            job.setStatus(JobRequest.Status.GONE);
            return job;
        }
        return job;
    }

    @DELETE
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/jobs/{jobId}")
    public JobRequest removeJob(@PathParam(value="jobId") String jobId) {
        System.out.println("-----queryJobStatus--- , jobId:" + jobId);
        JobRequest job = this.jobs.get(jobId);
        if (job == null) {
            job = new JobRequest();
            job.setStatus(JobRequest.Status.GONE);
            return job;
        }
        this.jobs.remove(jobId);
        job.setStatus(JobRequest.Status.GONE);
        return job;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories")
    public JobRequest createOrCloneRepository(Repository repository) {
        System.out.println("-----createOrCloneRepository--- , repository name:" + repository.getName());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CloneRepositoryRequest jobRequest = new CloneRepositoryRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepository(repository);
        this.jobs.put(id, (JobRequest)jobRequest);
        this.cloneJobRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}")
    public JobRequest deleteRepository(@PathParam(value="repositoryName") String repositoryName) {
        System.out.println("-----deleteRepository--- , repositoryName:" + repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateProjectRequest jobRequest = new CreateProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        this.jobs.put(id, (JobRequest)jobRequest);
        return jobRequest;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}/projects")
    public JobRequest createProject(@PathParam(value="repositoryName") String repositoryName, Entity project) {
        System.out.println("-----createProject--- , repositoryName:" + repositoryName + ", project name:" + project.getName());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateProjectRequest jobRequest = new CreateProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(project.getName());
        jobRequest.setDescription(project.getDescription());
        this.jobs.put(id, (JobRequest)jobRequest);
        this.createProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}/projects/{projectName}")
    public JobRequest deleteProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        System.out.println("-----deleteProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateProjectRequest jobRequest = new CreateProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.jobs.put(id, (JobRequest)jobRequest);
        return jobRequest;
    }

    @GET
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}/projects/{projectName}/maven/compile")
    public JobRequest compileProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        System.out.println("-----compileProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CompileProjectRequest jobRequest = new CompileProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setBuildConfig(mavenConfig);
        this.jobs.put(id, (JobRequest)jobRequest);
        this.compileProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @GET
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}/projects/{projectName}/maven/install")
    public JobRequest installProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        System.out.println("-----installProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        InstallProjectRequest jobRequest = new InstallProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setBuildConfig(mavenConfig);
        this.jobs.put(id, (JobRequest)jobRequest);
        this.installProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @GET
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}/projects/{projectName}/maven/test")
    public JobRequest testProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        System.out.println("-----testProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        TestProjectRequest jobRequest = new TestProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setBuildConfig(mavenConfig);
        this.jobs.put(id, (JobRequest)jobRequest);
        this.testProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="repositories/{repositoryName}/projects/{projectName}/maven/deploy")
    public JobRequest deployProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        System.out.println("-----deployProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        DeployProjectRequest jobRequest = new DeployProjectRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setBuildConfig(mavenConfig);
        this.jobs.put(id, (JobRequest)jobRequest);
        this.deployProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/groups")
    public JobRequest createGroup(Group group) {
        System.out.println("-----createGroup--- , Group name:" + group.getName() + ", Group owner:" + group.getOwner());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateGroupRequest jobRequest = new CreateGroupRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setGroupName(group.getName());
        jobRequest.setOwnder(group.getOwner());
        this.jobs.put(id, (JobRequest)jobRequest);
        this.createGroupRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/groups/{groupName}")
    public JobRequest deleteGroup(@PathParam(value="groupName") String groupName) {
        System.out.println("-----deleteGroup--- , Group name:" + groupName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateGroupRequest jobRequest = new CreateGroupRequest();
        jobRequest.setStatus(JobRequest.Status.ACCEPTED);
        jobRequest.setJodId(id);
        jobRequest.setGroupName(groupName);
        this.jobs.put(id, (JobRequest)jobRequest);
        return jobRequest;
    }

    public Path getRepositoryRootPath(String repositoryName) {
        Path repositoryRootPath = null;
        Iterator fsIterator = this.ioService.getFileSystems().iterator();
        if (fsIterator.hasNext()) {
            Iterator rootIterator;
            FileSystem fileSystem = (FileSystem)fsIterator.next();
            System.out.println("-----FileSystem id--- :" + ((FileSystemId)fileSystem).id());
            if (repositoryName.equalsIgnoreCase(((FileSystemId)fileSystem).id()) && (rootIterator = fileSystem.getRootDirectories().iterator()).hasNext()) {
                repositoryRootPath = (Path)rootIterator.next();
                System.out.println("-----rootPath--- :" + repositoryRootPath);
                DirectoryStream paths = this.ioService.newDirectoryStream(repositoryRootPath);
                for (Path child : paths) {
                    System.out.println("-----child--- :" + child);
                }
                return repositoryRootPath;
            }
        }
        return repositoryRootPath;
    }

    private static class Cache
    extends LinkedHashMap<String, JobRequest> {
        private int maxSize = 1000;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, JobRequest> stringFutureEntry) {
            return this.size() > this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

