/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.rest;

import java.util.HashMap;
import java.util.Iterator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.FileSystemId;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.services.shared.rest.BuildConfig;
import org.kie.workbench.common.services.shared.rest.Group;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.uberfire.backend.group.GroupService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class ProjectResourceDispatcher {
    @Inject
    RepositoryService repositoryService;
    @Inject
    protected ProjectService projectService;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioSystemService;
    @Inject
    protected BuildService buildService;
    @Inject
    GroupService groupService;
    @Inject
    private Event<JobResult> jobResultEvent;

    public void cloneRepository(String jobId, org.kie.workbench.common.services.shared.rest.Repository repository) {
        System.out.println("-----KieSessionAsyncJobRequestObserver:createOrCloneRepository--- , repository name:" + repository.getName());
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (repository.getRequestType() == null || "".equals(repository.getRequestType()) || !"new".equals(repository.getRequestType()) && !"clone".equals(repository.getRequestType())) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Repository request type can only be new or clone.");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        String scheme = "git";
        if ("new".equals(repository.getRequestType())) {
            if (repository.getName() == null || "".equals(repository.getName())) {
                result.setStatus(JobRequest.Status.BAD_REQUEST);
                result.setResult("Repository name must be provided");
                this.jobResultEvent.fire((Object)result);
                return;
            }
            HashMap<String, Object> env = new HashMap<String, Object>(3);
            env.put("username", repository.getUserName());
            env.put("crypt:password", repository.getPassword());
            env.put("init", true);
            this.repositoryService.createRepository("git", repository.getName(), env);
        } else if ("clone".equals(repository.getRequestType())) {
            if (repository.getName() == null || "".equals(repository.getName()) || repository.getGitURL() == null || "".equals(repository.getGitURL())) {
                result.setStatus(JobRequest.Status.BAD_REQUEST);
                result.setResult("Repository name and GitURL must be provided");
            }
            HashMap<String, String> env = new HashMap<String, String>(3);
            env.put("username", repository.getUserName());
            env.put("crypt:password", repository.getPassword());
            env.put("origin", repository.getGitURL());
            this.repositoryService.createRepository("git", repository.getName(), env);
        }
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public void createProject(String jobId, String repositoryName, String projectName) {
        System.out.println("-----KieSessionAsyncJobRequestObserver:createProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        POM pom = new POM();
        try {
            Project project = this.projectService.newProject(this.makeRepository(this.paths.convert(repositoryPath, false)), projectName, pom, "/");
        }
        catch (FileAlreadyExistsException e) {
            result.setStatus(JobRequest.Status.DUPLICATE_RESOURCE);
            result.setResult("Project [" + projectName + "] already exists");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    private Repository makeRepository(final org.uberfire.backend.vfs.Path repositoryRoot) {
        return new GitRepository(){

            public org.uberfire.backend.vfs.Path getRoot() {
                return repositoryRoot;
            }
        };
    }

    public void compileProject(String jobId, String repositoryName, String projectName, BuildConfig mavenConfig) {
        System.out.println("-----KieSessionAsyncJobRequestObserver:compileProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
        } else {
            Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
            if (project == null) {
                result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
                result.setResult("Project [" + projectName + "] does not exist");
                this.jobResultEvent.fire((Object)result);
                return;
            }
            this.buildService.build(project);
            result.setStatus(JobRequest.Status.SUCCESS);
            this.jobResultEvent.fire((Object)result);
        }
    }

    public void installProject(String jobId, String repositoryName, String projectName, BuildConfig mavenConfig) {
        System.out.println("-----installProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
        if (project == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        this.buildService.buildAndDeploy(project);
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public void deployProject(String jobId, String repositoryName, String projectName, BuildConfig config) {
        System.out.println("-----deployProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
        if (project == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        this.buildService.buildAndDeploy(project);
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public void createGroup(String jobId, Group group) {
        System.out.println("-----createGroup--- , Group name:" + group.getName() + ", Group owner:" + group.getOwner());
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (group.getName() == null || group.getOwner() == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Group name and owner must be provided");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        this.groupService.createGroup(group.getName(), group.getOwner());
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public Path getRepositoryRootPath(String repositoryName) {
        Path repositoryRootPath = null;
        Iterator fsIterator = this.ioSystemService.getFileSystems().iterator();
        if (fsIterator.hasNext()) {
            Iterator rootIterator;
            FileSystem fileSystem = (FileSystem)fsIterator.next();
            System.out.println("-----FileSystem id--- :" + ((FileSystemId)fileSystem).id());
            if (repositoryName.equalsIgnoreCase(((FileSystemId)fileSystem).id()) && (rootIterator = fileSystem.getRootDirectories().iterator()).hasNext()) {
                repositoryRootPath = (Path)rootIterator.next();
                System.out.println("-----rootPath--- :" + repositoryRootPath);
                DirectoryStream paths = this.ioSystemService.newDirectoryStream(repositoryRootPath);
                for (Path child : paths) {
                    System.out.println("-----child--- :" + child);
                }
                return repositoryRootPath;
            }
        }
        return repositoryRootPath;
    }
}

