/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import javax.enterprise.context.ApplicationScoped;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobRequestApprovalService {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestApprovalService.class);
    KieSession ksession = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobResult requestApproval(JobRequest jobRequest) {
        logger.info("Approval request for Job: " + jobRequest.getJobId() + " received.");
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobRequest.getJobId());
        jobResult.setStatus(jobRequest.getStatus());
        if (this.ksession == null) {
            return jobResult;
        }
        FactHandle fhJobRequest = null;
        FactHandle fhJobResult = null;
        try {
            fhJobRequest = this.ksession.insert((Object)jobRequest);
            fhJobResult = this.ksession.insert((Object)jobResult);
            this.ksession.fireAllRules();
        }
        finally {
            if (fhJobRequest != null) {
                this.ksession.delete(fhJobRequest);
            }
            if (fhJobResult != null) {
                this.ksession.delete(fhJobResult);
            }
        }
        logger.info("Approval request for Job: " + jobRequest.getJobId() + " result: " + jobRequest.getStatus());
        return jobResult;
    }
}

