/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.drools.workbench.common.services.rest.JobRequestHelper;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.resteasy.annotations.GZIP;
import org.kie.workbench.common.services.shared.rest.AddRepositoryToOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.BuildConfig;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrCloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.Entity;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.JobStatus;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryFromOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.RepositoryRequest;
import org.kie.workbench.common.services.shared.rest.RepositoryResponse;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;

@Path(value="/")
@Named
@GZIP
@ApplicationScoped
public class ProjectResource {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestHelper.class);
    @Context
    protected UriInfo uriInfo;
    @Inject
    protected ProjectService projectService;
    @Inject
    protected BuildService buildService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    OrganizationalUnitService organizationalUnitService;
    @Inject
    RepositoryService repositoryService;
    private Cache cache;
    private Map<String, JobResult> jobs;
    private AtomicLong counter = new AtomicLong(0L);
    private int maxCacheSize = 10000;
    @Inject
    private Event<CreateOrCloneRepositoryRequest> createOrCloneJobRequestEvent;
    @Inject
    private Event<RemoveRepositoryRequest> removeRepositoryRequestEvent;
    @Inject
    private Event<CreateProjectRequest> createProjectRequestEvent;
    @Inject
    private Event<CompileProjectRequest> compileProjectRequestEvent;
    @Inject
    private Event<InstallProjectRequest> installProjectRequestEvent;
    @Inject
    private Event<TestProjectRequest> testProjectRequestEvent;
    @Inject
    private Event<DeployProjectRequest> deployProjectRequestEvent;
    @Inject
    private Event<CreateOrganizationalUnitRequest> createOrganizationalUnitRequestEvent;
    @Inject
    private Event<AddRepositoryToOrganizationalUnitRequest> addRepositoryToOrganizationalUnitRequest;
    @Inject
    private Event<RemoveRepositoryFromOrganizationalUnitRequest> removeRepositoryFromOrganizationalUnitRequest;

    @PostConstruct
    public void start() {
        this.cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(this.cache);
    }

    public void onUpateJobStatus(@Observes JobResult jobResult) {
        String jobId = jobResult.getJobId();
        JobResult job = this.jobs.get(jobId);
        if (job == null) {
            logger.info("-----onUpateJobStatus--- , can not find jobId:" + jobId + ", the job has gone probably because its done and has been removed.");
            return;
        }
        jobResult.setLastModified(System.currentTimeMillis());
        this.jobs.put(jobId, jobResult);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    public JobResult getJobStatus(@PathParam(value="jobId") String jobId) {
        logger.info("-----getJobStatus--- , jobId:" + jobId);
        JobResult job = this.jobs.get(jobId);
        if (job == null) {
            logger.info("-----getJobStatus--- , can not find jobId:" + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        return job;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    public JobResult removeJob(@PathParam(value="jobId") String jobId) {
        logger.info("-----removeJob--- , jobId:" + jobId);
        JobResult job = this.jobs.get(jobId);
        if (job == null) {
            logger.info("-----removeJob--- , can not find jobId:" + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        this.jobs.remove(jobId);
        job.setStatus(JobStatus.GONE);
        return job;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repositories")
    public Collection<RepositoryResponse> getRepositories() {
        logger.info("-----getRepositories--- ");
        Collection repos = this.repositoryService.getRepositories();
        ArrayList<RepositoryResponse> result = new ArrayList<RepositoryResponse>();
        for (Repository r : repos) {
            RepositoryResponse repo = new RepositoryResponse();
            repo.setGitURL(r.getUri());
            repo.setName(r.getAlias());
            result.add(repo);
        }
        return result;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories")
    public JobRequest createOrCloneRepository(RepositoryRequest repository) {
        logger.info("-----createOrCloneRepository--- , repository name:" + repository.getName());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateOrCloneRepositoryRequest jobRequest = new CreateOrCloneRepositoryRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepository(repository);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.createOrCloneJobRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}")
    public JobRequest removeRepository(@PathParam(value="repositoryName") String repositoryName) {
        logger.info("-----removeRepository--- , repositoryName:" + repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveRepositoryRequest jobRequest = new RemoveRepositoryRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.removeRepositoryRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects")
    public JobRequest createProject(@PathParam(value="repositoryName") String repositoryName, Entity project) {
        logger.info("-----createProject--- , repositoryName:" + repositoryName + ", project name:" + project.getName());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateProjectRequest jobRequest = new CreateProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(project.getName());
        jobRequest.setDescription(project.getDescription());
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.createProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}")
    public JobRequest deleteProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.info("-----deleteProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"UNIMPLEMENTED").build());
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/compile")
    public JobRequest compileProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.info("-----compileProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CompileProjectRequest jobRequest = new CompileProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.compileProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/install")
    public JobRequest installProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.info("-----installProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        InstallProjectRequest jobRequest = new InstallProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.installProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/test")
    public JobRequest testProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        logger.info("-----testProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        TestProjectRequest jobRequest = new TestProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        jobRequest.setBuildConfig(mavenConfig);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.testProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/deploy")
    public JobRequest deployProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.info("-----deployProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        DeployProjectRequest jobRequest = new DeployProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.deployProjectRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits")
    public Collection<org.kie.workbench.common.services.shared.rest.OrganizationalUnit> getOrganizationalUnits() {
        logger.info("-----getOrganizationalUnits--- ");
        Collection origOrgUnits = this.organizationalUnitService.getOrganizationalUnits();
        ArrayList<org.kie.workbench.common.services.shared.rest.OrganizationalUnit> organizationalUnits = new ArrayList<org.kie.workbench.common.services.shared.rest.OrganizationalUnit>();
        for (OrganizationalUnit ou : origOrgUnits) {
            org.kie.workbench.common.services.shared.rest.OrganizationalUnit orgUnit = new org.kie.workbench.common.services.shared.rest.OrganizationalUnit();
            orgUnit.setName(ou.getName());
            orgUnit.setOwner(ou.getOwner());
            orgUnit.setRepositories(new ArrayList());
            ArrayList<String> repoNames = new ArrayList<String>();
            for (Repository r : ou.getRepositories()) {
                repoNames.add(r.getAlias());
            }
            orgUnit.setRepositories(repoNames);
            organizationalUnits.add(orgUnit);
        }
        return organizationalUnits;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits")
    public JobRequest createOrganizationalUnit(org.kie.workbench.common.services.shared.rest.OrganizationalUnit organizationalUnit) {
        logger.info("-----createOrganizationalUnit--- , OrganizationalUnit name:" + organizationalUnit.getName() + ", OrganizationalUnit owner:" + organizationalUnit.getOwner());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateOrganizationalUnitRequest jobRequest = new CreateOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnit.getName());
        jobRequest.setOwner(organizationalUnit.getOwner());
        jobRequest.setRepositories(organizationalUnit.getRepositories());
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.createOrganizationalUnitRequestEvent.fire((Object)jobRequest);
        return jobRequest;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}/repositories/{repositoryName}")
    public JobRequest addRepositoryToOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName, @PathParam(value="repositoryName") String repositoryName) {
        logger.info("-----addRepositoryToOrganizationalUnit--- , OrganizationalUnit name:" + organizationalUnitName + ", Repository name:" + repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        AddRepositoryToOrganizationalUnitRequest jobRequest = new AddRepositoryToOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        jobRequest.setRepositoryName(repositoryName);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.addRepositoryToOrganizationalUnitRequest.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}/repositories/{repositoryName}")
    public JobRequest removeRepositoryFromOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName, @PathParam(value="repositoryName") String repositoryName) {
        logger.info("-----removeRepositoryFromOrganizationalUnit--- , OrganizationalUnit name:" + organizationalUnitName + ", Repository name:" + repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveRepositoryFromOrganizationalUnitRequest jobRequest = new RemoveRepositoryFromOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        jobRequest.setRepositoryName(repositoryName);
        JobResult jobResult = new JobResult();
        jobResult.setJobId(id);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobs.put(id, jobResult);
        this.removeRepositoryFromOrganizationalUnitRequest.fire((Object)jobRequest);
        return jobRequest;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}")
    public JobRequest deleteOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName) {
        logger.info("-----deleteOrganizationalUnit--- , OrganizationalUnit name:" + organizationalUnitName);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"UNIMPLEMENTED").build());
    }

    public org.uberfire.java.nio.file.Path getRepositoryRootPath(String repositoryName) {
        org.uberfire.java.nio.file.Path repositoryRootPath = null;
        Iterator fsIterator = this.ioService.getFileSystems().iterator();
        if (fsIterator.hasNext()) {
            Iterator rootIterator;
            FileSystem fileSystem = (FileSystem)fsIterator.next();
            logger.info("-----FileSystem id--- :" + ((FileSystemId)fileSystem).id());
            if (repositoryName.equalsIgnoreCase(((FileSystemId)fileSystem).id()) && (rootIterator = fileSystem.getRootDirectories().iterator()).hasNext()) {
                repositoryRootPath = (org.uberfire.java.nio.file.Path)rootIterator.next();
                logger.info("-----rootPath--- :" + repositoryRootPath);
                DirectoryStream paths = this.ioService.newDirectoryStream(repositoryRootPath);
                for (org.uberfire.java.nio.file.Path child : paths) {
                    logger.info("-----child--- :" + child);
                }
                return repositoryRootPath;
            }
        }
        return repositoryRootPath;
    }

    private static class Cache
    extends LinkedHashMap<String, JobResult> {
        private int maxSize = 1000;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, JobResult> stringFutureEntry) {
            return this.size() > this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

