/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRequestApprovalService {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestApprovalService.class);
    @Inject
    @KSession(value="ksession1")
    private Instance<KieSession> ksessionInjected = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobResult requestApproval(JobRequest jobRequest) {
        logger.info("Approval request for Job: " + jobRequest.getJobId() + " received.");
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobRequest.getJobId());
        jobResult.setStatus(jobRequest.getStatus());
        KieSession ksession = this.getKieSession();
        if (ksession == null) {
            jobResult.setStatus(JobStatus.APPROVED);
            return jobResult;
        }
        FactHandle fhJobRequest = null;
        FactHandle fhJobResult = null;
        try {
            fhJobRequest = ksession.insert((Object)jobRequest);
            fhJobResult = ksession.insert((Object)jobResult);
            ksession.fireAllRules();
        }
        finally {
            if (fhJobRequest != null) {
                ksession.delete(fhJobRequest);
            }
            if (fhJobResult != null) {
                ksession.delete(fhJobResult);
            }
        }
        logger.info("Approval request for Job: " + jobRequest.getJobId() + " result: " + jobRequest.getStatus());
        return jobResult;
    }

    public KieSession getKieSession() {
        if (!this.ksessionInjected.isUnsatisfied()) {
            return (KieSession)this.ksessionInjected.get();
        }
        return null;
    }
}

