/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.common.services.rest.JobRequestApprovalService;
import org.drools.workbench.common.services.rest.JobRequestHelper;
import org.kie.workbench.common.services.shared.rest.AddRepositoryToOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrCloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.JobStatus;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryFromOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobRequestObserver {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestObserver.class);
    @Inject
    protected JobRequestHelper helper;
    @Inject
    protected JobRequestApprovalService approvalService;
    @Inject
    private Event<JobResult> jobResultEvent;

    public void onCreateOrCloneRepositoryRequest(@Observes CreateOrCloneRepositoryRequest jobRequest) {
        logger.info("CreateOrCloneRepositoryRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("CreateOrCloneRepositoryRequest event approved. Performing requested operation.");
        this.helper.createOrCloneRepository(jobRequest.getJobId(), jobRequest.getRepository());
    }

    public void onRemoveRepositoryRequest(@Observes RemoveRepositoryRequest jobRequest) {
        logger.info("RemoveRepositoryRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("RemoveRepositoryRequest event approved. Performing requested operation.");
        this.helper.removeRepository(jobRequest.getJobId(), jobRequest.getRepositoryName());
    }

    public void onCreateProjectRequest(@Observes CreateProjectRequest jobRequest) {
        logger.info("CreateProjectRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("CreateProjectRequest event approved. Performing requested operation.");
        this.helper.createProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onCompileProjectRequest(@Observes CompileProjectRequest jobRequest) {
        logger.info("CompileProjectRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("CompileProjectRequest event approved. Performing requested operation.");
        this.helper.compileProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onInstallProjectRequest(@Observes InstallProjectRequest jobRequest) {
        logger.info("InstallProjectRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("InstallProjectRequest event approved. Performing requested operation.");
        this.helper.installProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onTestProjectRequest(@Observes TestProjectRequest jobRequest) {
        logger.info("TestProjectRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("TestProjectRequest event approved. Performing requested operation.");
        this.helper.testProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onDeployProjectRequest(@Observes DeployProjectRequest jobRequest) {
        logger.info("DeployProjectRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("DeployProjectRequest event approved. Performing requested operation.");
        this.helper.installProject(jobRequest.getJobId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onCreateOrganizationalUnitRequest(@Observes CreateOrganizationalUnitRequest jobRequest) {
        logger.info("CreateOrganizationalUnitRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("CreateOrganizationalUnitRequest event approved. Performing requested operation.");
        this.helper.createOrganizationalUnit(jobRequest.getJobId(), jobRequest.getOrganizationalUnitName(), jobRequest.getOwner(), jobRequest.getRepositories());
    }

    public void onAddRepositoryToOrganizationalUnitRequest(@Observes AddRepositoryToOrganizationalUnitRequest jobRequest) {
        logger.info("AddRepositoryToOrganizationalUnitRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("AddRepositoryToOrganizationalUnitRequest event approved. Performing requested operation.");
        this.helper.addRepositoryToOrganizationalUnit(jobRequest.getJobId(), jobRequest.getOrganizationalUnitName(), jobRequest.getRepositoryName());
    }

    public void onAddRepositoryToOrganizationalUnitRequest(@Observes RemoveRepositoryFromOrganizationalUnitRequest jobRequest) {
        logger.info("RemoveRepositoryFromOrganizationalUnitRequest event received.");
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        logger.info("RemoveRepositoryFromOrganizationalUnitRequest event approved. Performing requested operation.");
        this.helper.removeRepositoryFromOrganizationalUnit(jobRequest.getJobId(), jobRequest.getOrganizationalUnitName(), jobRequest.getRepositoryName());
    }

    private boolean approveRequest(JobRequest jobRequest) {
        JobResult result = this.approvalService.requestApproval(jobRequest);
        return result.getStatus().equals((Object)JobStatus.APPROVED);
    }
}

