/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.testscenario.model.Failure;
import org.drools.workbench.screens.testscenario.model.TestResultMessage;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.shared.rest.BuildConfig;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.JobStatus;
import org.kie.workbench.common.services.shared.rest.RepositoryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.organizationalunit.impl.OrganizationalUnitImpl;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class JobRequestHelper {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestHelper.class);
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private ProjectService projectService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioSystemService;
    @Inject
    private BuildService buildService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ScenarioTestEditorService scenarioTestEditorService;

    public JobResult createOrCloneRepository(String jobId, RepositoryRequest repository) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (repository.getRequestType() == null || "".equals(repository.getRequestType()) || !"new".equals(repository.getRequestType()) && !"clone".equals(repository.getRequestType())) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Repository request type can only be new or clone.");
            return result;
        }
        String scheme = "git";
        if ("new".equals(repository.getRequestType())) {
            if (repository.getName() == null || "".equals(repository.getName())) {
                result.setStatus(JobStatus.BAD_REQUEST);
                result.setResult("Repository name must be provided");
                return result;
            }
            HashMap<String, Object> env = new HashMap<String, Object>(3);
            if (repository.getUserName() != null && !"".equals(repository.getUserName())) {
                env.put("username", repository.getUserName());
            }
            if (repository.getPassword() != null && !"".equals(repository.getPassword())) {
                env.put("crypt:password", repository.getPassword());
            }
            env.put("init", true);
            Repository newlyCreatedRepo = this.repositoryService.createRepository("git", repository.getName(), env);
            if (newlyCreatedRepo != null) {
                result.setStatus(JobStatus.SUCCESS);
                result.setResult("Alias: " + newlyCreatedRepo.getAlias() + ", Scheme: " + newlyCreatedRepo.getScheme() + ", Uri: " + newlyCreatedRepo.getUri());
            } else {
                result.setStatus(JobStatus.FAIL);
            }
        } else if ("clone".equals(repository.getRequestType())) {
            if (repository.getName() == null || "".equals(repository.getName()) || repository.getGitURL() == null || "".equals(repository.getGitURL())) {
                result.setStatus(JobStatus.BAD_REQUEST);
                result.setResult("Repository name and GitURL must be provided");
            }
            HashMap<String, String> env = new HashMap<String, String>(3);
            if (repository.getUserName() != null && !"".equals(repository.getUserName())) {
                env.put("username", repository.getUserName());
            }
            if (repository.getPassword() != null && !"".equals(repository.getPassword())) {
                env.put("crypt:password", repository.getPassword());
            }
            env.put("origin", repository.getGitURL());
            Repository newlyCreatedRepo = this.repositoryService.createRepository("git", repository.getName(), env);
            if (newlyCreatedRepo != null) {
                result.setStatus(JobStatus.SUCCESS);
                result.setResult("Alias: " + newlyCreatedRepo.getAlias() + ", Scheme: " + newlyCreatedRepo.getScheme() + ", Uri: " + newlyCreatedRepo.getUri());
            } else {
                result.setStatus(JobStatus.FAIL);
            }
        }
        return result;
    }

    public JobResult removeRepository(String jobId, String repositoryName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (repositoryName == null || "".equals(repositoryName)) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("Repository name must be provided");
            return result;
        }
        this.repositoryService.removeRepository(repositoryName);
        result.setStatus(JobStatus.SUCCESS);
        return result;
    }

    public JobResult createProject(String jobId, String repositoryName, String projectName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        POM pom = new POM();
        pom.getGav().setArtifactId(projectName);
        pom.getGav().setGroupId(projectName);
        pom.getGav().setVersion("1.0");
        try {
            this.projectService.newProject(this.makeRepository(Paths.convert((Path)repositoryPath)), projectName, pom, "/");
        }
        catch (FileAlreadyExistsException e) {
            result.setStatus(JobStatus.DUPLICATE_RESOURCE);
            result.setResult("Project [" + projectName + "] already exists");
            return result;
        }
        result.setStatus(JobStatus.SUCCESS);
        return result;
    }

    private Repository makeRepository(final org.uberfire.backend.vfs.Path repositoryRoot) {
        return new GitRepository(){

            public org.uberfire.backend.vfs.Path getRoot() {
                return repositoryRoot;
            }
        };
    }

    public JobResult compileProject(String jobId, String repositoryName, String projectName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        Project project = this.projectService.resolveProject(Paths.convert((Path)repositoryPath.resolve(projectName)));
        if (project == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        BuildResults buildResults = this.buildService.build(project);
        result.setDetailedResult(this.buildResultsToDetailedStringMessages(buildResults.getMessages()));
        result.setStatus(buildResults.getErrorMessages().isEmpty() ? JobStatus.SUCCESS : JobStatus.FAIL);
        return result;
    }

    private List<String> buildResultsToDetailedStringMessages(List<BuildMessage> messages) {
        ArrayList<String> result = new ArrayList<String>();
        for (BuildMessage message : messages) {
            String detailedStringMessage = "level:" + message.getLevel() + ", path:" + message.getPath() + ", text:" + message.getText();
            result.add(detailedStringMessage);
        }
        return result;
    }

    public JobResult installProject(String jobId, String repositoryName, String projectName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        Project project = this.projectService.resolveProject(Paths.convert((Path)repositoryPath.resolve(projectName)));
        if (project == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        BuildResults buildResults = null;
        try {
            buildResults = this.buildService.buildAndDeploy(project);
            result.setDetailedResult(buildResults == null ? null : this.deployResultToDetailedStringMessages(buildResults));
            result.setStatus(buildResults != null && buildResults.getErrorMessages().isEmpty() ? JobStatus.SUCCESS : JobStatus.FAIL);
        }
        catch (Throwable t) {
            ArrayList<String> errorResult = new ArrayList<String>();
            errorResult.add(t.getMessage());
            result.setDetailedResult(errorResult);
            result.setStatus(JobStatus.FAIL);
        }
        return result;
    }

    private List<String> deployResultToDetailedStringMessages(BuildResults deployResult) {
        GAV gav = deployResult.getGAV();
        List<String> result = this.buildResultsToDetailedStringMessages(deployResult.getErrorMessages());
        String detailedStringMessage = "artifactID:" + gav.getArtifactId() + ", groupId:" + gav.getGroupId() + ", version:" + gav.getVersion();
        result.add(detailedStringMessage);
        return result;
    }

    public JobResult testProject(String jobId, String repositoryName, String projectName, BuildConfig config) {
        final JobResult result = new JobResult();
        result.setJobId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        Project project = this.projectService.resolveProject(Paths.convert((Path)repositoryPath.resolve(projectName)));
        if (project == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        this.scenarioTestEditorService.runAllScenarios(project.getPomXMLPath(), (Event)new Event<TestResultMessage>(){

            public void fire(TestResultMessage event) {
                result.setDetailedResult(JobRequestHelper.this.testResultMessageToDetailedStringMessages(event));
                result.setStatus(event.wasSuccessful() ? JobStatus.SUCCESS : JobStatus.FAIL);
            }

            public Event<TestResultMessage> select(Annotation ... qualifiers) {
                return null;
            }

            public <U extends TestResultMessage> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
                return null;
            }
        });
        return result;
    }

    private List<String> testResultMessageToDetailedStringMessages(TestResultMessage message) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("wasSuccessuful: " + message.wasSuccessful());
        result.add("RunCoun: " + message.getRunCount());
        result.add("FailureCount: " + message.getFailureCount());
        for (Failure failure : message.getFailures()) {
            result.add("Failure: " + failure.getMessage());
        }
        return result;
    }

    public JobResult deployProject(String jobId, String repositoryName, String projectName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        Project project = this.projectService.resolveProject(Paths.convert((Path)repositoryPath.resolve(projectName)));
        if (project == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            return result;
        }
        BuildResults buildResults = this.buildService.buildAndDeploy(project);
        result.setDetailedResult(buildResults == null ? null : this.deployResultToDetailedStringMessages(buildResults));
        result.setStatus(buildResults != null && buildResults.getErrorMessages().isEmpty() ? JobStatus.SUCCESS : JobStatus.FAIL);
        return result;
    }

    public JobResult removeOrganizationalUnit(String jobId, String organizationalUnitName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (organizationalUnitName == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("OrganizationalUnit name must be provided");
            return result;
        }
        try {
            this.organizationalUnitService.removeOrganizationalUnit(organizationalUnitName);
            result.setStatus(JobStatus.SUCCESS);
        }
        catch (Exception e) {
            result.setStatus(JobStatus.FAIL);
            String errMsg = e.getClass().getSimpleName() + " thrown when trying to remove '" + organizationalUnitName + "': " + e.getMessage();
            result.setResult(errMsg);
            logger.error(errMsg, (Throwable)e);
        }
        return result;
    }

    public JobResult createOrganizationalUnit(String jobId, String organizationalUnitName, String organizationalUnitOwner, List<String> repositoryNameList) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (organizationalUnitName == null || organizationalUnitOwner == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("OrganizationalUnit name and owner must be provided");
            return result;
        }
        OrganizationalUnit organizationalUnit = null;
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>();
        if (repositoryNameList != null && repositoryNameList.size() > 0) {
            for (String repoName : repositoryNameList) {
                Path repositoryPath = this.getRepositoryRootPath(repoName);
                if (repositoryPath == null) {
                    result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
                    result.setResult("Repository [" + repoName + "] does not exist");
                    return result;
                }
                GitRepository repo = new GitRepository(repoName);
                repositories.add(repo);
            }
            organizationalUnit = this.organizationalUnitService.createOrganizationalUnit(organizationalUnitName, organizationalUnitOwner, repositories);
        } else {
            organizationalUnit = this.organizationalUnitService.createOrganizationalUnit(organizationalUnitName, organizationalUnitOwner);
        }
        if (organizationalUnit != null) {
            result.setResult("OrganizationalUnit " + organizationalUnit.getName() + " is created successfully.");
            result.setStatus(JobStatus.SUCCESS);
        } else {
            result.setStatus(JobStatus.FAIL);
        }
        return result;
    }

    public JobResult addRepositoryToOrganizationalUnit(String jobId, String organizationalUnitName, String repositoryName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (organizationalUnitName == null || repositoryName == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("OrganizationalUnit name and Repository name must be provided");
            return result;
        }
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(organizationalUnitName, null);
        GitRepository repo = new GitRepository(repositoryName);
        try {
            this.organizationalUnitService.addRepository((OrganizationalUnit)organizationalUnit, (Repository)repo);
        }
        catch (IllegalArgumentException e) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("OrganizationalUnit " + organizationalUnit.getName() + " not found");
            return result;
        }
        result.setStatus(JobStatus.SUCCESS);
        return result;
    }

    public JobResult removeRepositoryFromOrganizationalUnit(String jobId, String organizationalUnitName, String repositoryName) {
        JobResult result = new JobResult();
        result.setJobId(jobId);
        if (organizationalUnitName == null || repositoryName == null) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("OrganizationalUnit name and Repository name must be provided");
            return result;
        }
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobStatus.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            return result;
        }
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl(organizationalUnitName, null);
        GitRepository repo = new GitRepository(repositoryName);
        try {
            this.organizationalUnitService.removeRepository((OrganizationalUnit)organizationalUnit, (Repository)repo);
        }
        catch (IllegalArgumentException e) {
            result.setStatus(JobStatus.BAD_REQUEST);
            result.setResult("OrganizationalUnit " + organizationalUnit.getName() + " not found");
            return result;
        }
        result.setStatus(JobStatus.SUCCESS);
        return result;
    }

    private Path getRepositoryRootPath(String repositoryName) {
        Repository repo = this.repositoryService.getRepository(repositoryName);
        if (repo == null) {
            return null;
        }
        return Paths.convert((org.uberfire.backend.vfs.Path)repo.getRoot());
    }
}

