/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.drools.workbench.common.services.rest.JobRequestScheduler;
import org.drools.workbench.common.services.rest.JobResultManager;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.rest.RestOperationException;
import org.kie.workbench.common.services.shared.rest.AddRepositoryToOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.BuildConfig;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrCloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.Entity;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.JobStatus;
import org.kie.workbench.common.services.shared.rest.RemoveOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryFromOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.RepositoryRequest;
import org.kie.workbench.common.services.shared.rest.RepositoryResponse;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.io.IOService;

@Path(value="/")
@Named
@ApplicationScoped
public class ProjectResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    @Context
    protected UriInfo uriInfo;
    @Inject
    protected ProjectService projectService;
    @Inject
    protected BuildService buildService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private JobRequestScheduler jobRequestObserver;
    @Inject
    private JobResultManager jobManager;
    private AtomicLong counter = new AtomicLong(0L);
    private static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);

    private void addAcceptedJobResult(String jobId) {
        JobResult jobResult = new JobResult();
        jobResult.setJobId(jobId);
        jobResult.setStatus(JobStatus.ACCEPTED);
        this.jobManager.putJob(jobResult);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    public JobResult getJobStatus(@PathParam(value="jobId") String jobId) {
        logger.debug("-----getJobStatus--- , jobId: {}", (Object)jobId);
        JobResult job = this.jobManager.getJob(jobId);
        if (job == null) {
            logger.debug("-----getJobStatus--- , can not find jobId:" + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        return job;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/jobs/{jobId}")
    public JobResult removeJob(@PathParam(value="jobId") String jobId) {
        logger.debug("-----removeJob--- , jobId: {}", (Object)jobId);
        JobResult job = this.jobManager.removeJob(jobId);
        if (job == null) {
            logger.debug("-----removeJob--- , can not find jobId:" + jobId + ", the job has gone probably because its done and has been removed.");
            job = new JobResult();
            job.setStatus(JobStatus.GONE);
            return job;
        }
        job.setStatus(JobStatus.GONE);
        return job;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repositories")
    public Collection<RepositoryResponse> getRepositories() {
        logger.debug("-----getRepositories--- ");
        Collection repos = this.repositoryService.getRepositories();
        ArrayList<RepositoryResponse> result = new ArrayList<RepositoryResponse>();
        for (Repository r : repos) {
            RepositoryResponse repo = new RepositoryResponse();
            repo.setGitURL(r.getUri());
            repo.setName(r.getAlias());
            result.add(repo);
        }
        return result;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}")
    public RepositoryResponse getRepository(@PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----getRepository---, repository name: {}", (Object)repositoryName);
        Repository origRepo = this.checkRepositoryExistence(repositoryName);
        RepositoryResponse repo = new RepositoryResponse();
        repo.setGitURL(origRepo.getUri());
        repo.setName(origRepo.getAlias());
        return repo;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories")
    public Response createOrCloneRepository(RepositoryRequest repository) {
        logger.debug("-----createOrCloneRepository--- , repository name: {}", (Object)repository.getName());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateOrCloneRepositoryRequest jobRequest = new CreateOrCloneRepositoryRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepository(repository);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createOrCloneRepositoryRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}")
    public Response removeRepository(@PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----removeRepository--- , repositoryName: {}", (Object)repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveRepositoryRequest jobRequest = new RemoveRepositoryRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeRepositoryRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects")
    public Response createProject(@PathParam(value="repositoryName") String repositoryName, Entity project) {
        logger.debug("-----createProject--- , repositoryName: {} , project name: {}", (Object)repositoryName, (Object)project.getName());
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateProjectRequest jobRequest = new CreateProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(project.getName());
        jobRequest.setDescription(project.getDescription());
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}")
    public Response deleteProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----deleteProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"UNIMPLEMENTED").build());
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/compile")
    public Response compileProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----compileProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CompileProjectRequest jobRequest = new CompileProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.compileProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/install")
    public Response installProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----installProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        InstallProjectRequest jobRequest = new InstallProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.installProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/test")
    public Response testProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName, BuildConfig mavenConfig) {
        logger.debug("-----testProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        TestProjectRequest jobRequest = new TestProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        jobRequest.setBuildConfig(mavenConfig);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.testProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/repositories/{repositoryName}/projects/{projectName}/maven/deploy")
    public Response deployProject(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="projectName") String projectName) {
        logger.debug("-----deployProject--- , repositoryName: {}, project name: {}", (Object)repositoryName, (Object)projectName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        DeployProjectRequest jobRequest = new DeployProjectRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setRepositoryName(repositoryName);
        jobRequest.setProjectName(projectName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.deployProjectRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits")
    public Collection<org.kie.workbench.common.services.shared.rest.OrganizationalUnit> getOrganizationalUnits() {
        logger.debug("-----getOrganizationalUnits--- ");
        Collection origOrgUnits = this.organizationalUnitService.getOrganizationalUnits();
        ArrayList<org.kie.workbench.common.services.shared.rest.OrganizationalUnit> organizationalUnits = new ArrayList<org.kie.workbench.common.services.shared.rest.OrganizationalUnit>();
        for (OrganizationalUnit ou : origOrgUnits) {
            org.kie.workbench.common.services.shared.rest.OrganizationalUnit orgUnit = new org.kie.workbench.common.services.shared.rest.OrganizationalUnit();
            orgUnit.setName(ou.getName());
            orgUnit.setOwner(ou.getOwner());
            ArrayList<String> repoNames = new ArrayList<String>();
            for (Repository r : ou.getRepositories()) {
                repoNames.add(r.getAlias());
            }
            orgUnit.setRepositories(repoNames);
            organizationalUnits.add(orgUnit);
        }
        return organizationalUnits;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}")
    public org.kie.workbench.common.services.shared.rest.OrganizationalUnit getOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName) {
        logger.debug("-----getOrganizationalUnit ---, OrganizationalUnit name: {}", (Object)organizationalUnitName);
        OrganizationalUnit origOrgUnit = this.checkOrganizationalUnitExistence(organizationalUnitName);
        org.kie.workbench.common.services.shared.rest.OrganizationalUnit orgUnit = new org.kie.workbench.common.services.shared.rest.OrganizationalUnit();
        orgUnit.setName(origOrgUnit.getName());
        orgUnit.setOwner(origOrgUnit.getOwner());
        ArrayList<String> repoNames = new ArrayList<String>();
        for (Repository r : origOrgUnit.getRepositories()) {
            repoNames.add(r.getAlias());
        }
        orgUnit.setRepositories(repoNames);
        return orgUnit;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits")
    public Response createOrganizationalUnit(org.kie.workbench.common.services.shared.rest.OrganizationalUnit organizationalUnit) {
        logger.debug("-----createOrganizationalUnit--- , OrganizationalUnit name: {}, OrganizationalUnit owner: {}", (Object)organizationalUnit.getName(), (Object)organizationalUnit.getOwner());
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        CreateOrganizationalUnitRequest jobRequest = new CreateOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnit.getName());
        jobRequest.setOwner(organizationalUnit.getOwner());
        jobRequest.setRepositories(organizationalUnit.getRepositories());
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.createOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}/repositories/{repositoryName}")
    public Response addRepositoryToOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName, @PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----addRepositoryToOrganizationalUnit--- , OrganizationalUnit name: {}, Repository name: {}", (Object)organizationalUnitName, (Object)repositoryName);
        this.checkOrganizationalUnitExistence(organizationalUnitName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        AddRepositoryToOrganizationalUnitRequest jobRequest = new AddRepositoryToOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        jobRequest.setRepositoryName(repositoryName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.addRepositoryToOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}/repositories/{repositoryName}")
    public Response removeRepositoryFromOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName, @PathParam(value="repositoryName") String repositoryName) {
        logger.debug("-----removeRepositoryFromOrganizationalUnit--- , OrganizationalUnit name: {}, Repository name: {}", (Object)organizationalUnitName, (Object)repositoryName);
        this.checkOrganizationalUnitExistence(organizationalUnitName);
        this.checkRepositoryExistence(repositoryName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveRepositoryFromOrganizationalUnitRequest jobRequest = new RemoveRepositoryFromOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        jobRequest.setRepositoryName(repositoryName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeRepositoryFromOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/organizationalunits/{organizationalUnitName}")
    public Response deleteOrganizationalUnit(@PathParam(value="organizationalUnitName") String organizationalUnitName) {
        logger.debug("-----deleteOrganizationalUnit--- , OrganizationalUnit name: {}", (Object)organizationalUnitName);
        this.checkOrganizationalUnitExistence(organizationalUnitName);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        RemoveOrganizationalUnitRequest jobRequest = new RemoveOrganizationalUnitRequest();
        jobRequest.setStatus(JobStatus.ACCEPTED);
        jobRequest.setJobId(id);
        jobRequest.setOrganizationalUnitName(organizationalUnitName);
        this.addAcceptedJobResult(id);
        this.jobRequestObserver.removeOrganizationalUnitRequest(jobRequest);
        return this.createAcceptedStatusResponse((JobRequest)jobRequest);
    }

    private Repository checkRepositoryExistence(String repoName) {
        Repository repo = this.repositoryService.getRepository(repoName);
        if (repo == null) {
            throw RestOperationException.notFound((String)("Repository " + repoName + " does not exist."));
        }
        return repo;
    }

    private OrganizationalUnit checkOrganizationalUnitExistence(String orgUnitName) {
        OrganizationalUnit origOrgUnit = this.organizationalUnitService.getOrganizationalUnit(orgUnitName);
        if (origOrgUnit == null) {
            throw RestOperationException.notFound((String)("Organizational unit " + orgUnitName + " does not exist."));
        }
        return origOrgUnit;
    }

    private Response createAcceptedStatusResponse(JobRequest jobRequest) {
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)jobRequest).variant(defaultVariant).build();
    }
}

