/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.common.services.rest.cmd.AddRepositoryToOrgUnitCmd;
import org.drools.workbench.common.services.rest.cmd.CompileProjectCmd;
import org.drools.workbench.common.services.rest.cmd.CreateOrCloneRepositoryCmd;
import org.drools.workbench.common.services.rest.cmd.CreateOrgUnitCmd;
import org.drools.workbench.common.services.rest.cmd.CreateProjectCmd;
import org.drools.workbench.common.services.rest.cmd.DeployProjectCmd;
import org.drools.workbench.common.services.rest.cmd.InstallProjectCmd;
import org.drools.workbench.common.services.rest.cmd.RemoveOrgUnitCmd;
import org.drools.workbench.common.services.rest.cmd.RemoveRepositoryCmd;
import org.drools.workbench.common.services.rest.cmd.RemoveRepositoryFromOrgUnitCmd;
import org.drools.workbench.common.services.rest.cmd.TestProjectCmd;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.workbench.common.services.shared.rest.AddRepositoryToOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrCloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.RemoveOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryFromOrganizationalUnitRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobRequestScheduler {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestScheduler.class);
    @Inject
    private ExecutorService executorService;

    public void createOrCloneRepositoryRequest(CreateOrCloneRepositoryRequest jobRequest) {
        this.executorService.scheduleRequest(CreateOrCloneRepositoryCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void removeRepositoryRequest(RemoveRepositoryRequest jobRequest) {
        this.executorService.scheduleRequest(RemoveRepositoryCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void createProjectRequest(CreateProjectRequest jobRequest) {
        this.executorService.scheduleRequest(CreateProjectCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void compileProjectRequest(CompileProjectRequest jobRequest) {
        this.executorService.scheduleRequest(CompileProjectCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void installProjectRequest(InstallProjectRequest jobRequest) {
        this.executorService.scheduleRequest(InstallProjectCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void testProjectRequest(TestProjectRequest jobRequest) {
        this.executorService.scheduleRequest(TestProjectCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void deployProjectRequest(DeployProjectRequest jobRequest) {
        this.executorService.scheduleRequest(DeployProjectCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void createOrganizationalUnitRequest(CreateOrganizationalUnitRequest jobRequest) {
        this.executorService.scheduleRequest(CreateOrgUnitCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void addRepositoryToOrganizationalUnitRequest(AddRepositoryToOrganizationalUnitRequest jobRequest) {
        this.executorService.scheduleRequest(AddRepositoryToOrgUnitCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void removeRepositoryFromOrganizationalUnitRequest(RemoveRepositoryFromOrganizationalUnitRequest jobRequest) {
        this.executorService.scheduleRequest(RemoveRepositoryFromOrgUnitCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    public void removeOrganizationalUnitRequest(RemoveOrganizationalUnitRequest jobRequest) {
        this.executorService.scheduleRequest(RemoveOrgUnitCmd.class.getName(), this.getContext((JobRequest)jobRequest));
    }

    protected CommandContext getContext(JobRequest jobRequest) {
        CommandContext ctx = new CommandContext();
        ctx.setData("JobRequest", (Object)jobRequest);
        ctx.setData("retries", (Object)0);
        return ctx;
    }
}

