/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest.cmd;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.drools.workbench.common.services.rest.JobRequestApprovalService;
import org.drools.workbench.common.services.rest.JobRequestHelper;
import org.drools.workbench.common.services.rest.JobResultManager;
import org.jbpm.executor.cdi.CDIUtils;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobCommand
implements Command {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJobCommand.class);
    public static final String JOB_REQUEST_KEY = "JobRequest";

    protected JobRequestHelper getHelper(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (JobRequestHelper)CDIUtils.createBean(JobRequestHelper.class, (BeanManager)beanManager, (Annotation[])new Annotation[0]);
    }

    protected JobRequest getJobRequest(CommandContext ctx) {
        return (JobRequest)ctx.getData(JOB_REQUEST_KEY);
    }

    protected ExecutionResults getEmptyResult() {
        return new ExecutionResults();
    }

    private JobRequestApprovalService getApprovalService(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (JobRequestApprovalService)CDIUtils.createBean(JobRequestApprovalService.class, (BeanManager)beanManager, (Annotation[])new Annotation[0]);
    }

    private JobResultManager getJobManager(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return (JobResultManager)CDIUtils.createBean(JobResultManager.class, (BeanManager)beanManager, (Annotation[])new Annotation[0]);
    }

    private BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        JobRequestApprovalService approvalService = this.getApprovalService(ctx);
        JobRequest request = this.getJobRequest(ctx);
        JobResult result = approvalService.requestApproval(request);
        logger.debug("--- job {} ---, status: {}", (Object)result.getJobId(), (Object)result.getStatus());
        JobResultManager jobMgr = this.getJobManager(ctx);
        result.setLastModified(System.currentTimeMillis());
        jobMgr.putJob(result);
        if (JobStatus.APPROVED.equals((Object)result.getStatus())) {
            try {
                result = this.internalExecute(ctx, request);
            }
            catch (Exception e) {
                result.setStatus(JobStatus.SERVER_ERROR);
                result.setResult("Request failed because of " + e.getClass().getSimpleName() + ": " + e.getMessage());
                logger.error("{} [{}] failed because of thrown {}: {}", new Object[]{request.getClass().getSimpleName(), request.getJobId(), e.getClass().getSimpleName(), e.getMessage(), e});
            }
            logger.debug("--- job {} ---, status: {}", (Object)result.getJobId(), (Object)result.getStatus());
            result.setLastModified(System.currentTimeMillis());
            jobMgr.putJob(result);
        }
        return this.getEmptyResult();
    }

    protected abstract JobResult internalExecute(CommandContext var1, JobRequest var2) throws Exception;
}

