/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.common.services.rest;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.rest.backend.JobRequestApprovalService;
import org.guvnor.rest.client.JobRequest;
import org.guvnor.rest.client.JobResult;
import org.guvnor.rest.client.JobStatus;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRequestApprovalServiceImpl
implements JobRequestApprovalService {
    private static final Logger logger = LoggerFactory.getLogger(JobRequestApprovalServiceImpl.class);
    @Inject
    @KSession(value="ksession1")
    private Instance<KieSession> ksessionInjected = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestApproval(JobRequest jobRequest, JobResult jobResult) {
        logger.debug("--- approve job request ---, job: {} ", (Object)jobRequest.getJobId());
        KieSession ksession = this.getKieSession();
        if (ksession == null) {
            jobResult.setStatus(JobStatus.APPROVED);
            return;
        }
        FactHandle fhJobRequest = null;
        FactHandle fhJobResult = null;
        try {
            fhJobRequest = ksession.insert((Object)jobRequest);
            fhJobResult = ksession.insert((Object)jobResult);
            ksession.fireAllRules();
        }
        finally {
            if (fhJobRequest != null) {
                ksession.delete(fhJobRequest);
            }
            if (fhJobResult != null) {
                ksession.delete(fhJobResult);
            }
        }
        jobResult.setLastModified(System.currentTimeMillis());
    }

    private KieSession getKieSession() {
        if (!this.ksessionInjected.isUnsatisfied()) {
            return (KieSession)this.ksessionInjected.get();
        }
        return null;
    }
}

