/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors.condition;

import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Condition;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.maps.InspectorFactory;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.StringConditionInspector;

public class ConditionInspectorFactory
extends InspectorFactory<ConditionInspector, Condition> {
    public ConditionInspectorFactory(AnalyzerConfiguration configuration) {
        super(configuration);
    }

    public ConditionInspector make(Condition condition) {
        if (condition instanceof FieldCondition) {
            return this.makeFieldCondition((FieldCondition)condition);
        }
        return null;
    }

    private ConditionInspector makeFieldCondition(FieldCondition condition) {
        if (!condition.getValues().isEmpty() && condition.getFirstValue() instanceof String) {
            return new StringConditionInspector((FieldCondition<String>)condition, this.configuration);
        }
        if (!condition.getValues().isEmpty() && condition.getFirstValue() instanceof Boolean) {
            return new BooleanConditionInspector((FieldCondition<Boolean>)condition, this.configuration);
        }
        if (!condition.getValues().isEmpty() && condition.getFirstValue() instanceof Integer) {
            return new NumericIntegerConditionInspector((FieldCondition<Integer>)condition, this.configuration);
        }
        return new ComparableConditionInspector(condition, this.configuration);
    }
}

