/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.CheckWhiteList;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspectorDumper;
import org.drools.workbench.services.verifier.core.checks.base.PairCheck;

public class DetectConflictingRowsCheck
extends PairCheck {
    private static final CheckType CHECK_TYPE = CheckType.CONFLICTING_ROWS;

    public DetectConflictingRowsCheck(RuleInspector ruleInspector, RuleInspector other) {
        super(ruleInspector, other);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.ruleInspector.conflicts(this.other)) {
            this.hasIssues = true;
        }
    }

    @Override
    public boolean isActive(CheckWhiteList whiteList) {
        return whiteList.getAllowedCheckTypes().contains(CHECK_TYPE);
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, CHECK_TYPE, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1, this.other.getRowIndex() + 1)));
        issue.setDebugMessage(new RuleInspectorDumper(this.ruleInspector).dump() + " ## " + new RuleInspectorDumper(this.other).dump());
        return issue;
    }
}

