/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.relations.Conflict;
import org.drools.workbench.services.verifier.api.client.relations.HumanReadable;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.ImpossibleMatchIssue;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.services.verifier.core.checks.base.SingleCheck;

public class DetectImpossibleMatchCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectImpossibleMatchCheck(RuleInspector ruleInspector) {
        super(ruleInspector, CheckType.IMPOSSIBLE_MATCH);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        this.conflict = Conflict.EMPTY;
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            ConditionsInspectorMultiMap conditionsInspector = patternInspector.getConditionsInspector();
            Conflict conflict = conditionsInspector.hasConflicts();
            if (!conflict.foundIssue()) continue;
            this.hasIssues = true;
            this.conflict = conflict;
        }
    }

    @Override
    public Issue getIssue() {
        String fieldName = "";
        String fieldFactType = "";
        if (((Conflict)this.conflict.getOrigin()).getConflictedItem() instanceof ComparableConditionInspector) {
            Field field = ((ComparableConditionInspector)((Conflict)this.conflict.getOrigin()).getConflictedItem()).getField();
            fieldName = field.getName();
            fieldFactType = field.getFactType();
        }
        return new ImpossibleMatchIssue(Severity.ERROR, this.checkType, Integer.toString(this.ruleInspector.getRowIndex() + 1), fieldFactType, fieldName, HumanReadable.toHumanReadableString((Object)((Conflict)this.conflict.getOrigin()).getConflictedItem()), HumanReadable.toHumanReadableString((Object)((Conflict)this.conflict.getOrigin()).getConflictingItem()), new Integer[]{this.ruleInspector.getRowIndex() + 1});
    }
}

