/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.relations.Conflict;
import org.drools.workbench.services.verifier.api.client.relations.HumanReadable;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.MultipleValuesForOneActionIssue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.SingleCheck;

public class DetectMultipleValuesForOneActionCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectMultipleValuesForOneActionCheck(RuleInspector ruleInspector) {
        super(ruleInspector, CheckType.MULTIPLE_VALUES_FOR_ONE_ACTION);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        this.conflict = Conflict.EMPTY;
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            Conflict result = patternInspector.getActionsInspector().hasConflicts();
            if (!result.foundIssue()) continue;
            this.hasIssues = true;
            this.conflict = result;
            return;
        }
    }

    @Override
    public Issue getIssue() {
        return new MultipleValuesForOneActionIssue(Severity.WARNING, this.checkType, HumanReadable.toHumanReadableString((Object)this.conflict.getConflictedItem()), HumanReadable.toHumanReadableString((Object)this.conflict.getConflictingItem()), new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

