/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.CheckWhiteList;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.PairCheck;

public class DetectRedundantRowsCheck
extends PairCheck {
    private CheckType issueType = null;
    private boolean allowRedundancyReporting = true;
    private boolean allowSubsumptionReporting = true;

    public DetectRedundantRowsCheck(RuleInspector ruleInspector, RuleInspector other) {
        super(ruleInspector, other);
    }

    @Override
    public Issue getIssue() {
        return new Issue(Severity.WARNING, this.issueType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1, this.other.getRowIndex() + 1)));
    }

    @Override
    public boolean isActive(CheckWhiteList whiteList) {
        this.allowRedundancyReporting = whiteList.getAllowedCheckTypes().contains(CheckType.REDUNDANT_ROWS);
        this.allowSubsumptionReporting = whiteList.getAllowedCheckTypes().contains(CheckType.SUBSUMPTANT_ROWS);
        return this.allowRedundancyReporting || this.allowSubsumptionReporting;
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.other.atLeastOneActionHasAValue()) {
            boolean subsumes = this.ruleInspector.subsumes(this.other);
            if (this.allowRedundancyReporting && subsumes && this.other.subsumes(this.ruleInspector)) {
                this.hasIssues = true;
                this.issueType = CheckType.REDUNDANT_ROWS;
            } else if (this.allowSubsumptionReporting && subsumes) {
                this.hasIssues = true;
                this.issueType = CheckType.SUBSUMPTANT_ROWS;
            }
        }
    }
}

