/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import org.drools.workbench.services.verifier.api.client.configuration.CheckWhiteList;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.reporting.SingleHitLostIssue;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.PairCheck;

public class SingleHitCheck
extends PairCheck {
    private static final CheckType CHECK_TYPE = CheckType.SINGLE_HIT_LOST;

    public SingleHitCheck(RuleInspector ruleInspector, RuleInspector other) {
        super(ruleInspector, other);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.ruleInspector.getConditionsInspectors().subsumes(this.other.getConditionsInspectors())) {
            this.hasIssues = true;
        }
    }

    @Override
    public Issue getIssue() {
        return new SingleHitLostIssue(Severity.NOTE, CHECK_TYPE, Integer.toString(this.ruleInspector.getRowIndex() + 1), Integer.toString(this.other.getRowIndex() + 1));
    }

    @Override
    public boolean isActive(CheckWhiteList whiteList) {
        return whiteList.getAllowedCheckTypes().contains(CHECK_TYPE);
    }
}

