/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.configuration.CheckWhiteList;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.DetectConflictingRowsCheck;
import org.drools.workbench.services.verifier.core.checks.DetectDeficientRowsCheck;
import org.drools.workbench.services.verifier.core.checks.DetectEmptyRowCheck;
import org.drools.workbench.services.verifier.core.checks.DetectImpossibleMatchCheck;
import org.drools.workbench.services.verifier.core.checks.DetectMissingActionCheck;
import org.drools.workbench.services.verifier.core.checks.DetectMissingConditionCheck;
import org.drools.workbench.services.verifier.core.checks.DetectMultipleValuesForOneActionCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantActionFactFieldCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantActionValueCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantConditionsCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantRowsCheck;
import org.drools.workbench.services.verifier.core.checks.RangeCheck;
import org.drools.workbench.services.verifier.core.checks.SingleHitCheck;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckBundle;
import org.uberfire.commons.validation.PortablePreconditions;

public class CheckFactory {
    private final CheckWhiteList checkWhiteList;
    private final AnalyzerConfiguration configuration;

    public CheckFactory(AnalyzerConfiguration configuration) {
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        this.checkWhiteList = (CheckWhiteList)PortablePreconditions.checkNotNull((String)"checkWhiteList", (Object)configuration.getCheckWhiteList());
    }

    protected Set<Check> makeSingleChecks(RuleInspector ruleInspector) {
        return new HashSet<Check>(this.filter(new DetectImpossibleMatchCheck(ruleInspector), new DetectMultipleValuesForOneActionCheck(ruleInspector), new DetectEmptyRowCheck(ruleInspector), new DetectMissingActionCheck(ruleInspector), new DetectMissingConditionCheck(ruleInspector), new DetectDeficientRowsCheck(ruleInspector, this.configuration), new RangeCheck(ruleInspector, this.configuration), new DetectRedundantActionFactFieldCheck(ruleInspector), new DetectRedundantActionValueCheck(ruleInspector), new DetectRedundantConditionsCheck(ruleInspector)));
    }

    protected Optional<PairCheckBundle> makePairRowCheck(RuleInspector ruleInspector, RuleInspector other) {
        List<Check> filteredSet = this.filter(new DetectConflictingRowsCheck(ruleInspector, other), new DetectRedundantRowsCheck(ruleInspector, other), new SingleHitCheck(ruleInspector, other));
        if (filteredSet.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PairCheckBundle(ruleInspector, other, filteredSet));
    }

    private List<Check> filter(Check ... checks) {
        ArrayList<Check> checkHashSet = new ArrayList<Check>();
        for (Check check : checks) {
            if (!check.isActive(this.checkWhiteList)) continue;
            checkHashSet.add(check);
        }
        return checkHashSet;
    }
}

