/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.IndexImpl;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.core.cache.RuleInspectorCache;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.AnalyzerConfigurationMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuleInspectorCacheTest {
    private RuleInspectorCache cache;

    @Before
    public void setUp() throws Exception {
        IndexImpl index = new IndexImpl();
        AnalyzerConfigurationMock configuration = new AnalyzerConfigurationMock();
        this.cache = new RuleInspectorCache((Index)index, (AnalyzerConfiguration)configuration);
        this.cache.addRule(new Rule(Integer.valueOf(0), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(1), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(2), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(3), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(4), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(5), (AnalyzerConfiguration)configuration));
        this.cache.addRule(new Rule(Integer.valueOf(6), (AnalyzerConfiguration)configuration));
    }

    @Test
    public void testInit() throws Exception {
        Assert.assertEquals((long)7L, (long)this.cache.all().size());
    }

    @Test
    public void testRemoveRow() throws Exception {
        this.cache.removeRow(3);
        Collection all = this.cache.all();
        Assert.assertEquals((long)6L, (long)all.size());
        this.assertContainsRowNumbers(all, 0, 1, 2, 3, 4, 5);
    }

    private void assertContainsRowNumbers(Collection<RuleInspector> all, int ... numbers) {
        ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
        for (RuleInspector ruleInspector : all) {
            int rowIndex = ruleInspector.getRowIndex();
            rowNumbers.add(rowIndex);
        }
        for (Object number : (Object)numbers) {
            Assert.assertTrue((String)rowNumbers.toString(), (boolean)rowNumbers.contains((int)number));
        }
    }
}

