/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.configuration.CheckConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.PairCheck;

public class DetectRedundantRowsCheck
extends PairCheck {
    private CheckType issueType = null;
    private boolean allowRedundancyReporting = true;
    private boolean allowSubsumptionReporting = true;

    public DetectRedundantRowsCheck(RuleInspector ruleInspector, RuleInspector other, AnalyzerConfiguration configuration) {
        super(ruleInspector, other, configuration);
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1, this.other.getRowIndex() + 1)));
    }

    @Override
    public boolean isActive(CheckConfiguration checkConfiguration) {
        this.allowRedundancyReporting = checkConfiguration.getCheckConfiguration().contains(CheckType.REDUNDANT_ROWS);
        this.allowSubsumptionReporting = checkConfiguration.getCheckConfiguration().contains(CheckType.SUBSUMPTANT_ROWS);
        return this.allowRedundancyReporting || this.allowSubsumptionReporting;
    }

    @Override
    protected CheckType getCheckType() {
        return this.issueType;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.other.atLeastOneActionHasAValue()) {
            boolean subsumes = this.ruleInspector.subsumes(this.other);
            if (this.allowRedundancyReporting && subsumes && this.other.subsumes(this.ruleInspector)) {
                this.hasIssues = true;
                this.issueType = CheckType.REDUNDANT_ROWS;
            } else if (this.allowSubsumptionReporting && subsumes) {
                this.hasIssues = true;
                this.issueType = CheckType.SUBSUMPTANT_ROWS;
            }
        }
    }
}

