/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.main;

import com.google.gwt.user.client.Command;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.Status;
import org.drools.workbench.services.verifier.api.client.StatusUpdate;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.core.cache.RuleInspectorCache;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.CheckRunManager;
import org.drools.workbench.services.verifier.core.main.Reporter;
import org.uberfire.commons.validation.PortablePreconditions;

public class Analyzer {
    private final RuleInspectorCache cache;
    private final CheckRunManager checkRunManager;
    private final AnalyzerConfiguration configuration;
    private final Reporter reporter;
    private final StatusUpdate onStatus = this.getOnStatusCommand();
    private final Command onCompletion = this.getOnCompletionCommand();

    public Analyzer(Reporter reporter, Index index, AnalyzerConfiguration configuration) {
        this.reporter = (Reporter)PortablePreconditions.checkNotNull((String)"reporter", (Object)reporter);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        this.checkRunManager = new CheckRunManager(configuration.getRunnerType());
        this.cache = new RuleInspectorCache((Index)PortablePreconditions.checkNotNull((String)"index", (Object)index), configuration);
        this.cache.reset();
    }

    public void newColumn(Column column) {
        this.cache.newColumn(column);
    }

    public void newRule(Rule rule) {
        RuleInspector ruleInspector = this.cache.addRule(rule);
        this.checkRunManager.addChecks(ruleInspector.getChecks());
    }

    public void deleteColumn(int firstColumnIndex) {
        this.cache.deleteColumns(firstColumnIndex);
    }

    public void resetChecks() {
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.checkRunManager.addChecks(ruleInspector.getChecks());
        }
    }

    private Set<Issue> getIssues() {
        HashSet<Issue> unorderedIssues = new HashSet<Issue>();
        for (RuleInspector ruleInspector : this.cache.all()) {
            for (Check check : ruleInspector.getChecks()) {
                if (!check.hasIssues()) continue;
                unorderedIssues.add(check.getIssue());
            }
        }
        return unorderedIssues;
    }

    public void removeRule(Integer rowDeleted) {
        this.checkRunManager.remove(this.cache.removeRow(rowDeleted));
        this.analyze();
    }

    public void start() {
        if (this.checkRunManager.isEmpty()) {
            this.resetChecks();
            this.analyze();
        } else {
            this.reporter.sendReport(this.getIssues());
        }
    }

    public void update(Set<Integer> canBeUpdated) {
        HashSet<Check> checks = new HashSet<Check>();
        for (Integer row : canBeUpdated) {
            checks.addAll(this.cache.getRuleInspector(row).getChecks());
        }
        if (!checks.isEmpty()) {
            this.checkRunManager.addChecks(checks);
        }
    }

    public void analyze() {
        this.checkRunManager.run(this.onStatus, this.onCompletion);
    }

    protected StatusUpdate getOnStatusCommand() {
        return new StatusUpdate(){

            public void update(int currentStartIndex, int endIndex, int size) {
                Analyzer.this.reporter.sendStatus(new Status(Analyzer.this.configuration.getWebWorkerUUID(), currentStartIndex, endIndex, size));
            }
        };
    }

    protected Command getOnCompletionCommand() {
        return new Command(){

            public void execute() {
                Analyzer.this.reporter.sendReport(Analyzer.this.getIssues());
            }
        };
    }
}

