/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors.condition;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.index.keys.Values;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.services.verifier.core.checks.AnalyzerConfigurationMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class ComparableConditionInspectorSubsumptionTest {
    private final Comparable value1;
    private final Comparable value2;
    private final String operator1;
    private final String operator2;
    private final boolean aSubsumesB;
    private final boolean bSubsumesA;
    private final Field field = (Field)Mockito.mock(Field.class);

    public ComparableConditionInspectorSubsumptionTest(String operator1, Comparable value1, String operator2, Comparable value2, boolean aSubsumesB, boolean bSubsumesA) {
        this.value1 = value1;
        this.value2 = value2;
        this.operator1 = operator1;
        this.operator2 = operator2;
        this.aSubsumesB = aSubsumesB;
        this.bSubsumesA = bSubsumesA;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> testData() {
        return Arrays.asList({"==", 0.5, "==", 0.5, true, true}, {"!=", 0.5, "!=", 0.5, true, true}, {">", 0.5, ">", 0.5, true, true}, {">=", 0.5, ">=", 0.5, true, true}, {"<", 0.5, "<", 0.5, true, true}, {"<=", 0.5, "<=", 0.5, true, true}, {"==", 0.5, "==", 1.5, false, false}, {"==", 0.5, "!=", 0.5, false, false}, {"==", 0.5, ">", 0.5, false, false}, {"==", 0.5, ">", 10.5, false, false}, {"==", 0.5, ">=", 1.5, false, false}, {"==", 0.5, ">=", 10.5, false, false}, {"==", 0.5, "<", 0.5, false, false}, {"==", 0.5, "<", -10.5, false, false}, {"==", 0.5, "<=", -1.5, false, false}, {"==", 0.5, "<=", -10.5, false, false}, {"==", 0.5, "!=", 1.5, true, false}, {"==", 0.5, ">", -1.5, false, true}, {"==", 0.5, ">", -10.5, false, true}, {"==", 0.5, ">=", 0.5, false, true}, {"==", 0.5, ">=", -10.5, false, true}, {"==", 0.5, "<", 1.5, false, true}, {"==", 0.5, "<", 10.5, false, true}, {"==", 0.5, "<=", 0.5, false, true}, {"==", 0.5, "<=", 10.5, false, true}, {"!=", 0.5, "!=", 1.5, false, false}, {"!=", 0.5, ">", -1.5, false, false}, {"!=", 0.5, ">", -10.5, false, false}, {"!=", 0.5, ">=", 0.5, false, false}, {"!=", 0.5, ">=", -10.5, false, false}, {"!=", 0.5, "<", 1.5, false, false}, {"!=", 0.5, "<", 10.5, false, false}, {"!=", 0.5, "<=", 0.5, false, false}, {"!=", 0.5, "<=", 10.5, false, false}, {"!=", 0.5, ">", 0.5, true, false}, {"!=", 0.5, ">", 10.5, true, false}, {"!=", 0.5, ">=", 1.5, true, false}, {"!=", 0.5, ">=", 10.5, true, false}, {"!=", 0.5, "<", 0.5, true, false}, {"!=", 0.5, "<", -10.5, true, false}, {"!=", 0.5, "<=", -1.5, true, false}, {"!=", 0.5, "<=", -10.5, true, false}, {">", 0.5, "<", 0.5, false, false}, {">", 0.5, "<", -10.5, false, false}, {">", 0.5, "<", 10.5, false, false}, {">", 0.5, "<=", 0.5, false, false}, {">", 0.5, "<=", -10.5, false, false}, {">", 0.5, "<=", 10.5, false, false}, {">", 0.5, ">", 1.5, true, false}, {">", 0.5, ">", 10.5, true, false}, {">", 0.5, ">=", 0.5, false, true}, {">", 0.5, ">=", 10.5, true, false}, {">=", 0.5, "<", 0.5, false, false}, {">=", 0.5, "<", -10.5, false, false}, {">=", 0.5, "<", 10.5, false, false}, {">=", 0.5, "<=", -1.5, false, false}, {">=", 0.5, "<=", -10.5, false, false}, {">=", 0.5, "<=", 10.5, false, false}, {">=", 0.5, ">=", 1.5, true, false}, {">=", 0.5, ">=", 10.5, true, false}, {"<", 0.5, "<", 1.5, false, true}, {"<", 0.5, "<", 10.5, false, true}, {"<", 0.5, "<=", 0.5, false, true}, {"<", 0.5, "<=", 10.5, false, true}, {"<=", 0.5, "<=", 1.5, false, true}, {"<=", 0.5, "<=", 10.5, false, true});
    }

    @Test
    public void testASubsumesB() {
        ComparableConditionInspector a = this.getCondition(this.value1, this.operator1);
        ComparableConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(a, b, this.aSubsumesB), (Object)this.aSubsumesB, (Object)a.subsumes((Object)b));
    }

    @Test
    public void testBSubsumesA() {
        ComparableConditionInspector a = this.getCondition(this.value1, this.operator1);
        ComparableConditionInspector b = this.getCondition(this.value2, this.operator2);
        Assert.assertEquals((String)this.getAssertDescription(b, a, this.bSubsumesA), (Object)this.bSubsumesA, (Object)b.subsumes((Object)a));
    }

    private String getAssertDescription(ComparableConditionInspector a, ComparableConditionInspector b, boolean subsumptionExpected) {
        return String.format("Expected condition '%s' %sto subsume condition '%s':", a.toHumanReadableString(), subsumptionExpected ? "" : "not ", b.toHumanReadableString());
    }

    private ComparableConditionInspector getCondition(Comparable value, String operator) {
        AnalyzerConfigurationMock configurationMock = new AnalyzerConfigurationMock();
        return new ComparableConditionInspector(new FieldCondition(this.field, (Column)Mockito.mock(Column.class), operator, new Values(new Comparable[]{value}), (AnalyzerConfiguration)configurationMock), (AnalyzerConfiguration)configurationMock);
    }
}

