/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors.action;

import java.util.Iterator;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Action;
import org.drools.workbench.services.verifier.api.client.index.FieldAction;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionInspector;

public class FieldActionInspector
extends ActionInspector {
    public FieldActionInspector(FieldAction action, AnalyzerConfiguration configuration) {
        super((Action)action, configuration);
    }

    @Override
    public String toHumanReadableString() {
        return ((FieldAction)this.action).getField().getName() + " = " + this.getValuesString();
    }

    private String getValuesString() {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = this.action.getValues().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public boolean isRedundant(Object other) {
        if (other instanceof FieldActionInspector) {
            if (this.areFieldsEqual((FieldActionInspector)other)) {
                return super.isRedundant(other);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean conflicts(Object other) {
        if (other instanceof FieldActionInspector) {
            if (this.areFieldsEqual((FieldActionInspector)other)) {
                return super.conflicts(other);
            }
            return false;
        }
        return false;
    }

    private boolean areFieldsEqual(FieldActionInspector other) {
        FieldAction otherAction = (FieldAction)other.action;
        return ((FieldAction)this.action).getField().equals((Object)otherAction.getField());
    }
}

