/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.RuleInspectorCache;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.OneToManyCheck;

public class DetectDeficientRowsCheck
extends OneToManyCheck {
    public DetectDeficientRowsCheck(final RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, new RuleInspectorCache.Filter(){

            @Override
            public boolean accept(RuleInspector other) {
                return !ruleInspector.getRule().getUuidKey().equals(other.getRule().getUuidKey()) && !other.isEmpty();
            }
        }, configuration, CheckType.DEFICIENT_ROW);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.ruleInspector.isEmpty()) {
            return;
        }
        if (this.ruleInspector.atLeastOneConditionHasAValue() && this.thereIsAtLeastOneRow()) {
            this.hasIssues = this.isDeficient();
        }
    }

    private boolean isDeficient() {
        for (RuleInspector other : this.getOtherRows()) {
            if (this.isDeficient(other)) continue;
            return false;
        }
        return true;
    }

    private boolean isDeficient(RuleInspector other) {
        return this.ruleInspector.isDeficient(other);
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

