/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.SingleCheck;

public class DetectMissingActionCheck
extends SingleCheck {
    public DetectMissingActionCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.MISSING_ACTION);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.ruleInspector.atLeastOneConditionHasAValue()) {
            this.hasIssues = !this.ruleInspector.atLeastOneActionHasAValue();
        }
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

