/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.reporting.SingleHitLostIssue;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.PairCheck;

public class SingleHitCheck
extends PairCheck {
    public SingleHitCheck(RuleInspector ruleInspector, RuleInspector other, AnalyzerConfiguration configuration) {
        super(ruleInspector, other, configuration);
    }

    @Override
    protected CheckType getCheckType() {
        return CheckType.SINGLE_HIT_LOST;
    }

    @Override
    public void check() {
        this.hasIssues = false;
        if (this.ruleInspector.getConditionsInspectors().subsumes(this.other.getConditionsInspectors())) {
            this.hasIssues = true;
        }
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.NOTE;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new SingleHitLostIssue(severity, checkType, Integer.toString(this.ruleInspector.getRowIndex() + 1), Integer.toString(this.other.getRowIndex() + 1));
    }
}

