/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.maps.MultiSet;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.CheckFactory;
import org.drools.workbench.services.verifier.core.checks.base.OneToManyCheck;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckBundle;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckStorage;

public class CheckStorage {
    private final PairCheckStorage pairCheckStorage = new PairCheckStorage();
    private final MultiSet<RuleInspector, Check> ruleInspectorChecks = new MultiSet();
    private final MultiSet<RuleInspector, OneToManyCheck> oneToManyChecks = new MultiSet();
    private final CheckFactory checkFactory;

    public CheckStorage(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
    }

    private Set<Check> makeSingleRowChecks(RuleInspector ruleInspector) {
        Set<Check> checks = this.checkFactory.makeSingleChecks(ruleInspector);
        for (Check check : checks) {
            if (!(check instanceof OneToManyCheck)) continue;
            this.oneToManyChecks.put((Object)ruleInspector, (Object)((OneToManyCheck)check));
        }
        this.ruleInspectorChecks.addAllValues((Object)ruleInspector, checks);
        return checks;
    }

    private HashSet<Check> makePairRowChecks(RuleInspector ruleInspector, Collection<RuleInspector> all) {
        HashSet<Check> checks = new HashSet<Check>();
        for (RuleInspector other : all) {
            Optional<PairCheckBundle> pairCheckList;
            if (ruleInspector.equals(other) || !(pairCheckList = this.checkFactory.makePairRowCheck(ruleInspector, other)).isPresent()) continue;
            checks.add(pairCheckList.get());
            this.pairCheckStorage.add(pairCheckList.get());
        }
        return checks;
    }

    public Set<Check> getChecks(RuleInspector ruleInspector) {
        HashSet<Check> result = new HashSet<Check>();
        result.addAll(this.getRuleInspectorChecks(ruleInspector));
        result.addAll(this.getReferencingChecks(ruleInspector));
        result.addAll(this.oneToManyChecks.allValues());
        return result;
    }

    private Collection<PairCheckBundle> getReferencingChecks(RuleInspector ruleInspector) {
        Collection<PairCheckBundle> checks = this.pairCheckStorage.get(ruleInspector);
        if (checks == null) {
            return Collections.EMPTY_LIST;
        }
        return checks;
    }

    private Collection<Check> getRuleInspectorChecks(RuleInspector ruleInspector) {
        Collection checks = this.ruleInspectorChecks.get((Object)ruleInspector);
        if (checks == null) {
            return Collections.EMPTY_LIST;
        }
        return checks;
    }

    public Set<Check> remove(RuleInspector ruleInspector) {
        HashSet<Check> result = new HashSet<Check>();
        result.addAll(this.removeRuleInspectorChecks(ruleInspector));
        result.addAll(this.pairCheckStorage.remove(ruleInspector));
        result.addAll(this.removeOneToMany(ruleInspector));
        return result;
    }

    private Collection<Check> removeRuleInspectorChecks(RuleInspector ruleInspector) {
        Collection remove = this.ruleInspectorChecks.remove((Object)ruleInspector);
        if (remove == null) {
            return Collections.EMPTY_LIST;
        }
        return remove;
    }

    private Collection<OneToManyCheck> removeOneToMany(RuleInspector ruleInspector) {
        Collection remove = this.oneToManyChecks.remove((Object)ruleInspector);
        if (remove == null) {
            return Collections.EMPTY_LIST;
        }
        return remove;
    }

    public void makeChecks(RuleInspector ruleInspector) {
        this.makeSingleRowChecks(ruleInspector);
        Set knownRuleInspectors = this.ruleInspectorChecks.keys();
        this.makePairRowChecks(ruleInspector, knownRuleInspectors);
        for (RuleInspector other : knownRuleInspectors) {
            Optional<PairCheckBundle> pairCheckList;
            if (other.equals(ruleInspector) || !(pairCheckList = this.checkFactory.makePairRowCheck(other, ruleInspector)).isPresent()) continue;
            this.pairCheckStorage.add(pairCheckList.get());
        }
    }
}

