/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors;

import java.util.ArrayList;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Actions;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.Conditions;
import org.drools.workbench.services.verifier.api.client.index.DataType;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.FieldAction;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.index.ObjectField;
import org.drools.workbench.services.verifier.api.client.index.keys.Values;
import org.drools.workbench.services.verifier.core.cache.inspectors.FieldInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.services.verifier.core.checks.AnalyzerConfigurationMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FieldInspectorUpdateTest {
    @Mock
    ObjectField objectField;
    @Mock
    RuleInspectorUpdater ruleInspectorUpdater;
    private FieldCondition fieldCondition;
    private FieldAction fieldAction;
    private AnalyzerConfigurationMock configurationMock;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        Field field = (Field)Mockito.spy((Object)new Field(this.objectField, "org.Person", "String", "name", (AnalyzerConfiguration)this.configurationMock));
        this.fieldCondition = this.makeCondition(field);
        this.fieldAction = this.makeAction(field);
        new FieldInspector(field, this.ruleInspectorUpdater, (AnalyzerConfiguration)new AnalyzerConfigurationMock());
    }

    private FieldCondition makeCondition(Field field) {
        FieldCondition fieldAction = new FieldCondition(field, (Column)Mockito.mock(Column.class), "==", new Values(new Comparable[]{Integer.valueOf(11)}), (AnalyzerConfiguration)this.configurationMock);
        ArrayList<FieldCondition> actionsList = new ArrayList<FieldCondition>();
        actionsList.add(fieldAction);
        Conditions conditions = new Conditions(actionsList);
        Mockito.when((Object)field.getConditions()).thenReturn((Object)conditions);
        return fieldAction;
    }

    private FieldAction makeAction(Field field) {
        FieldAction fieldAction = new FieldAction(field, (Column)Mockito.mock(Column.class), DataType.DataTypes.NUMERIC, new Values(new Comparable[]{Integer.valueOf(11)}), (AnalyzerConfiguration)this.configurationMock);
        ArrayList<FieldAction> actionsList = new ArrayList<FieldAction>();
        actionsList.add(fieldAction);
        Actions actions = new Actions(actionsList);
        Mockito.when((Object)field.getActions()).thenReturn((Object)actions);
        return fieldAction;
    }

    @Test
    public void updateAction() throws Exception {
        this.fieldAction.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((RuleInspectorUpdater)Mockito.verify((Object)this.ruleInspectorUpdater)).resetActionsInspectors();
    }

    @Test
    public void updateCondition() throws Exception {
        this.fieldCondition.setValue(new Values(new Comparable[]{Integer.valueOf(20)}));
        ((RuleInspectorUpdater)Mockito.verify((Object)this.ruleInspectorUpdater)).resetConditionsInspectors();
    }
}

