/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors;

import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.ObjectType;
import org.drools.workbench.services.verifier.api.client.index.Pattern;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.services.verifier.core.checks.AnalyzerConfigurationMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PatternInspectorTest {
    private AnalyzerConfigurationMock configurationMock;
    private PatternInspector a;
    private PatternInspector b;

    @Before
    public void setUp() throws Exception {
        this.configurationMock = new AnalyzerConfigurationMock();
        this.a = new PatternInspector(new Pattern("a", new ObjectType("org.Person", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        this.b = new PatternInspector(new Pattern("b", new ObjectType("org.Person", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
    }

    @Test
    public void testRedundancy01() throws Exception {
        Assert.assertTrue((boolean)this.a.isRedundant((Object)this.b));
        Assert.assertTrue((boolean)this.b.isRedundant((Object)this.a));
    }

    @Test
    public void testRedundancy02() throws Exception {
        PatternInspector x = new PatternInspector(new Pattern("x", new ObjectType("org.Address", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assert.assertFalse((boolean)x.isRedundant((Object)this.b));
        Assert.assertFalse((boolean)this.b.isRedundant((Object)x));
    }

    @Test
    public void testSubsumpt01() throws Exception {
        Assert.assertTrue((boolean)this.a.subsumes((Object)this.b));
        Assert.assertTrue((boolean)this.b.subsumes((Object)this.a));
    }

    @Test
    public void testSubsumpt02() throws Exception {
        PatternInspector x = new PatternInspector(new Pattern("x", new ObjectType("org.Address", (AnalyzerConfiguration)this.configurationMock), (AnalyzerConfiguration)this.configurationMock), (RuleInspectorUpdater)Mockito.mock(RuleInspectorUpdater.class), (AnalyzerConfiguration)Mockito.mock(AnalyzerConfiguration.class));
        Assert.assertFalse((boolean)x.subsumes((Object)this.b));
        Assert.assertFalse((boolean)this.b.subsumes((Object)x));
    }
}

