/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.configuration.CheckConfiguration;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.DetectConflictingRowsCheck;
import org.drools.workbench.services.verifier.core.checks.DetectDeficientRowsCheck;
import org.drools.workbench.services.verifier.core.checks.DetectEmptyRowCheck;
import org.drools.workbench.services.verifier.core.checks.DetectImpossibleMatchCheck;
import org.drools.workbench.services.verifier.core.checks.DetectMissingActionCheck;
import org.drools.workbench.services.verifier.core.checks.DetectMissingConditionCheck;
import org.drools.workbench.services.verifier.core.checks.DetectMultipleValuesForOneActionCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantActionFactFieldCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantActionValueCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantConditionsCheck;
import org.drools.workbench.services.verifier.core.checks.DetectRedundantRowsCheck;
import org.drools.workbench.services.verifier.core.checks.RangeCheck;
import org.drools.workbench.services.verifier.core.checks.SingleHitCheck;
import org.drools.workbench.services.verifier.core.checks.base.Check;
import org.drools.workbench.services.verifier.core.checks.base.PairCheckBundle;
import org.uberfire.commons.validation.PortablePreconditions;

public class CheckFactory {
    private final CheckConfiguration checkConfiguration;
    private final AnalyzerConfiguration configuration;

    public CheckFactory(AnalyzerConfiguration configuration) {
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        this.checkConfiguration = (CheckConfiguration)PortablePreconditions.checkNotNull((String)"checkWhiteList", (Object)configuration.getCheckConfiguration());
    }

    protected Set<Check> makeSingleChecks(RuleInspector ruleInspector) {
        return new HashSet<Check>(this.filter(new DetectImpossibleMatchCheck(ruleInspector, this.configuration), new DetectMultipleValuesForOneActionCheck(ruleInspector, this.configuration), new DetectEmptyRowCheck(ruleInspector, this.configuration), new DetectMissingActionCheck(ruleInspector, this.configuration), new DetectMissingConditionCheck(ruleInspector, this.configuration), new DetectDeficientRowsCheck(ruleInspector, this.configuration), new RangeCheck(ruleInspector, this.configuration), new DetectRedundantActionFactFieldCheck(ruleInspector, this.configuration), new DetectRedundantActionValueCheck(ruleInspector, this.configuration), new DetectRedundantConditionsCheck(ruleInspector, this.configuration)));
    }

    protected Optional<PairCheckBundle> makePairRowCheck(RuleInspector ruleInspector, RuleInspector other) {
        List<Check> filteredSet = this.filter(new DetectConflictingRowsCheck(ruleInspector, other, this.configuration), new DetectRedundantRowsCheck(ruleInspector, other, this.configuration), new SingleHitCheck(ruleInspector, other, this.configuration));
        if (filteredSet.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PairCheckBundle(ruleInspector, other, filteredSet));
    }

    private List<Check> filter(Check ... checks) {
        ArrayList<Check> checkHashSet = new ArrayList<Check>();
        for (Check check : checks) {
            if (!check.isActive(this.checkConfiguration)) continue;
            checkHashSet.add(check);
        }
        return checkHashSet;
    }
}

