/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.checks.base.OneToManyCheck;

public class DetectDeficientRowsCheck
extends OneToManyCheck {
    public DetectDeficientRowsCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, other -> !ruleInspector.getRule().getUuidKey().equals(other.getRule().getUuidKey()) && !other.isEmpty(), configuration, CheckType.DEFICIENT_ROW);
    }

    @Override
    public boolean check() {
        this.hasIssues = !this.ruleInspector.isEmpty() && this.ruleInspector.atLeastOneConditionHasAValue() && this.thereIsAtLeastOneRow() && this.isDeficient();
        return this.hasIssues;
    }

    private boolean isDeficient() {
        return !this.getOtherRows().stream().anyMatch(other -> !this.isDeficient((RuleInspector)other));
    }

    private boolean isDeficient(RuleInspector other) {
        return this.ruleInspector.isDeficient(other);
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1)));
    }
}

