/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.checks.base;

import org.drools.workbench.services.verifier.api.client.configuration.RunnerType;
import org.drools.workbench.services.verifier.core.checks.base.CheckRunnerFactory;
import org.drools.workbench.services.verifier.core.checks.base.GWTCheckRunner;
import org.drools.workbench.services.verifier.core.checks.base.JavaCheckRunner;
import org.junit.Assert;
import org.junit.Test;

public class CheckRunnerFactoryTest {
    @Test(expected=IllegalArgumentException.class)
    public void passInNull() throws Exception {
        CheckRunnerFactory.make(null);
    }

    @Test
    public void makeGWTRunner() throws Exception {
        Assert.assertTrue((boolean)(CheckRunnerFactory.make((RunnerType)RunnerType.GWT) instanceof GWTCheckRunner));
    }

    @Test
    public void makeJavaRunner() throws Exception {
        Assert.assertTrue((boolean)(CheckRunnerFactory.make((RunnerType)RunnerType.JAVA) instanceof JavaCheckRunner));
    }

    @Test
    public void allEnumValuesReturnARunner() throws Exception {
        for (RunnerType runnerType : RunnerType.values()) {
            Assert.assertNotNull((Object)CheckRunnerFactory.make((RunnerType)runnerType));
        }
    }
}

