/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors;

import java.util.Collection;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.index.Fields;
import org.drools.workbench.services.verifier.api.client.index.Pattern;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.maps.util.HasConflicts;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.maps.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.relations.Conflict;
import org.drools.workbench.services.verifier.api.client.relations.HumanReadable;
import org.drools.workbench.services.verifier.api.client.relations.IsConflicting;
import org.drools.workbench.services.verifier.api.client.relations.IsRedundant;
import org.drools.workbench.services.verifier.api.client.relations.IsSubsuming;
import org.drools.workbench.services.verifier.api.client.relations.RelationResolver;
import org.drools.workbench.services.verifier.core.cache.inspectors.FieldInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspectorUpdater;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.kie.soup.commons.validation.PortablePreconditions;

public class PatternInspector
implements HasConflicts,
IsConflicting,
IsSubsuming,
IsRedundant,
HumanReadable,
HasKeys {
    private final UUIDKey uuidKey;
    private final Pattern pattern;
    private final AnalyzerConfiguration configuration;
    private final InspectorList<FieldInspector> inspectorList;
    private final RelationResolver relationResolver;

    public PatternInspector(Pattern pattern, RuleInspectorUpdater ruleInspectorUpdater, AnalyzerConfiguration configuration) {
        this.pattern = (Pattern)PortablePreconditions.checkNotNull((String)"pattern", (Object)pattern);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        this.uuidKey = configuration.getUUID((HasKeys)this);
        this.inspectorList = new InspectorList(configuration);
        this.relationResolver = new RelationResolver(this.inspectorList);
        this.makeFieldInspectors(((Fields.FieldSelector)pattern.getFields().where(Field.uuid().any()).select()).all(), ruleInspectorUpdater);
    }

    private void makeFieldInspectors(Collection<Field> fields, RuleInspectorUpdater ruleInspectorUpdater) {
        this.inspectorList.clear();
        for (Field field : fields) {
            this.inspectorList.add((HasUUID)new FieldInspector(field, ruleInspectorUpdater, this.configuration));
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean conflicts(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.conflicts(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.isRedundant(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof PatternInspector) {
            if (this.pattern.getObjectType().getType().equals(((PatternInspector)other).getPattern().getObjectType().getType())) {
                return this.inspectorList.subsumes(((PatternInspector)other).inspectorList);
            }
            return false;
        }
        return false;
    }

    public Conflict hasConflicts() {
        return this.relationResolver.resolveConflict(this.inspectorList);
    }

    public ActionsInspectorMultiMap getActionsInspector() {
        ActionsInspectorMultiMap actionsInspector = new ActionsInspectorMultiMap(this.configuration);
        for (FieldInspector fieldInspector : this.inspectorList) {
            actionsInspector.addAllValues((Comparable)fieldInspector.getObjectField(), fieldInspector.getActionInspectorList());
        }
        return actionsInspector;
    }

    public ConditionsInspectorMultiMap getConditionsInspector() {
        ConditionsInspectorMultiMap conditionsInspector = new ConditionsInspectorMultiMap(this.configuration);
        for (FieldInspector fieldInspector : this.inspectorList) {
            if (fieldInspector.getConditionInspectorList().isEmpty()) continue;
            conditionsInspector.addAllValues((Comparable)fieldInspector.getObjectField(), fieldInspector.getConditionInspectorList());
        }
        return conditionsInspector;
    }

    public String toHumanReadableString() {
        return this.pattern.getName();
    }

    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }
}

