/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.core.cache.inspectors;

import org.drools.workbench.services.verifier.api.client.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.relations.HumanReadable;
import org.drools.workbench.services.verifier.core.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.core.cache.inspectors.condition.ConditionsInspectorMultiMap;

public class RuleInspectorDumper {
    private StringBuilder dump = new StringBuilder();
    private RuleInspector ruleInspector;

    public RuleInspectorDumper(RuleInspector ruleInspector) {
        this.ruleInspector = ruleInspector;
    }

    public String dump() {
        this.dump.append("Rule: ");
        this.dump.append(this.ruleInspector.getRowIndex());
        this.dump.append("\n");
        this.dump.append("\n");
        this.dumpPatterns();
        this.dumpConditions();
        this.dumpActions();
        return this.dump.toString();
    }

    private void dumpPatterns() {
        this.dump.append("Patterns{\n");
        InspectorList<PatternInspector> patternsInspector = this.ruleInspector.getPatternsInspector();
        for (PatternInspector patternInspector : patternsInspector) {
            this.dump.append("Pattern{\n");
            this.dump.append(patternInspector.getPattern().getName());
            this.dump.append("\n");
            this.dump.append("Conditions{\n");
            this.dumpCondition(patternInspector.getConditionsInspector());
            this.dump.append("}\n");
            this.dump.append("Actions{\n");
            this.dumpAction(patternInspector.getActionsInspector());
            this.dump.append("}\n");
        }
        this.dump.append("}\n");
    }

    private void dumpConditions() {
        this.dump.append("Conditions{\n");
        for (ConditionsInspectorMultiMap conditionsInspectorMultiMap : this.ruleInspector.getConditionsInspectors()) {
            this.dumpCondition(conditionsInspectorMultiMap);
        }
        for (ConditionInspector conditionInspector : this.ruleInspector.getBrlConditionsInspectors()) {
            this.dump.append(conditionInspector.toHumanReadableString());
        }
        this.dump.append("}\n");
    }

    private void dumpActions() {
        this.dump.append("Actions{\n");
        for (ActionsInspectorMultiMap actionsInspectorMultiMap : this.ruleInspector.getActionsInspectors()) {
            this.dumpAction(actionsInspectorMultiMap);
        }
        for (ActionInspector actionInspector : this.ruleInspector.getBrlActionInspectors()) {
            this.dump.append(actionInspector.toHumanReadableString());
        }
        this.dump.append("}\n");
    }

    private void dumpAction(ActionsInspectorMultiMap actionsInspectorMultiMap) {
        for (Object object : actionsInspectorMultiMap.allValues()) {
            this.dump.append("Action{\n");
            if (object instanceof HumanReadable) {
                this.dump.append(((HumanReadable)object).toHumanReadableString());
            } else {
                this.dump.append(object.toString());
            }
            this.dump.append("}\n");
        }
    }

    private void dumpCondition(ConditionsInspectorMultiMap conditionsInspectorMultiMap) {
        for (ConditionInspector conditionInspector : conditionsInspectorMultiMap.allValues()) {
            this.dump.append("Condition{\n");
            this.dump.append(conditionInspector.toHumanReadableString());
            this.dump.append("}\n");
        }
    }
}

